/*=========================================================================
                                                                                
  Program:   gdcm
  Module:    $RCSfile: Dcm2VtkImageData.cxx,v $
  Language:  C++
  Date:      $Date: 2009/07/17 14:14:04 $
  Version:   $Revision: 1.1 $
                                                                                
  Copyright (c) CREATIS (Centre de Recherche et d'Applications en Traitement de
  l'Image). All rights reserved. See Doc/License.txt or
  http://www.creatis.insa-lyon.fr/Public/Gdcm/License.html for details.
                                                                                
     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.
                                      
=========================================================================*/

/** 
 * 
 */

#include "gdcmCommon.h"
#include "gdcmDebug.h"
#include "gdcmUtil.h"
#include "gdcmDirList.h"

#include "gdcmArgMgr.h"
#include "vtkGdcmReader.h"

// ===================================================================================================


int main(int argc, char *argv[])
{
   START_USAGE(usage)
   " \n Dcm2VtkImageData : \n                                                 ",
   " usage: Dcm2VtkImageData dirin=rootDirectoryName                          ",
   "                         nb=number of Slices                              ",
   "                   [debug] [verbose]                                      ",
   "                                                                          ",
   "  debug      : developper wants to run the program in 'debug mode'        ",
   FINISH_USAGE
   
   // ------------ Initialize Arguments Manager ---------------- 
    
   GDCM_NAME_SPACE::ArgMgr *am= new GDCM_NAME_SPACE::ArgMgr(argc, argv);
  
   if (argc == 1 || am->ArgMgrDefined("usage") )
   {
      am->ArgMgrUsage(usage); // Display 'usage'
      delete am;
      return 1;
   }

   const char *dirNamein;   
   dirNamein  = am->ArgMgrGetString("dirin",".");
   int nb = am->ArgMgrGetInt("nb",1);

   if (am->ArgMgrDefined("debug"))
      GDCM_NAME_SPACE::Debug::DebugOn();

   bool verbose  = am->ArgMgrDefined("verbose");      
             
   /* if unused Param we give up */
   if ( am->ArgMgrPrintUnusedLabels() )
   {
      am->ArgMgrUsage(usage);
      delete am;
      return 1;
   } 
      
   delete am;  // we don't need Argument Manager any longer  

   // ----------- End Arguments Manager ---------
   
//2dseq_Slice_0.dcm   

   // ----- Begin Processing -----
   vtkGdcmReader *reader = vtkGdcmReader::New();
   std::vector <vtkImageData *> output;
   char nomFich[1024]; // Hope it's enough !

   for (int i = 0; i < nb; i++)
   {
      sprintf(nomFich, "%s%c2dseq_Slice_%d.dcm", 
         dirNamein, 
         GDCM_NAME_SPACE::GDCM_FILESEPARATOR, 
         i);
      if (verbose)
         std::cout << "file to be processed : [" << nomFich << ")" << std::endl;
      reader->SetFileName(nomFich);
      reader->Update();
      output.push_back(reader->GetOutput());    
   }
   
   // Here you call the function that processes the vtkImageData vector  
} 


