
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include "brukerdataset.h"
//#include "brukerkspaceobject.h"

#include "gdcmArgMgr.h"
#include "gdcmDebug.h"
//#include "gdcmUtil.h"


int main(int argc, char *argv[])
{   
   START_USAGE(usage)
   " \n PrintParameterFile : \n                                                      ",
   " - explores the given Bruker parameter file,                         ",
   " - prints its content,                      ",
   " usage: BrukerToMhd filein=rukerParameterFile                               ",
   "                   [debug] [verbose]                           ",
   "                                                                          ",
   "  debug      : developper wants to run the program in 'debug mode'        ",
   FINISH_USAGE

// ------------ Initialize Arguments Manager ----------------  
   GDCM_NAME_SPACE::ArgMgr *am= new GDCM_NAME_SPACE::ArgMgr(argc, argv);
  
   if (argc == 1 || am->ArgMgrDefined("usage") )
   {
      am->ArgMgrUsage(usage); // Display 'usage'
      delete am;
      return 1;
   }
   
   const char *fileNamein;   
   fileNamein  = am->ArgMgrWantString("filein",usage);
   
   if (am->ArgMgrDefined("debug"))
      GDCM_NAME_SPACE::Debug::DebugOn();
      
     /* if unused Param we give up */
   if ( am->ArgMgrPrintUnusedLabels() )
   {
      am->ArgMgrUsage(usage);
      delete am;
      return 1;
   } 

   delete am;  // we don't need Argument Manager any longer

   // ----------- End Arguments Manager ---------
       
  BrukerDataSet br1;
  //BrukerKspaceObject bro1(br1);
  std::string file2Read(fileNamein);
  br1.LoadFile(file2Read);
std::cout << "=============== FillMap =================" << std::endl;
  br1.FillMap();
std::cout << "=============== End FillMap =================" << std::endl;

  std::cout << "=============== PrintSelf =================" << std::endl;
  br1.PrintSelf();
  std::cout << "=============== End PrintSelf =============" << std::endl;

  return EXIT_SUCCESS;
}
