
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include "brukerdataset.h"
#include "brukerkspaceobject.h"
#include "brukerimage.h"


int main(int argc, char *argv[])
{
   BrukerDataSet acqp1, reco1;
   std::string file2Read1("/home/denis/TestDicom/kiwidicom.QZ1/3/acqp");
   std::string file2Read2("/home/denis/TestDicom/kiwidicom.QZ1/3/pdata/1/reco");
   //std::string file2Read("/home/denis/TestDicom/mcao31a.pc1-exam_fabien/6/acqp");
   //std::string file2Read("/home/denis/TestDicom/mcao31a.pc1-exam_fabien/6/pdata/1/reco");
   //std::string file2Read("/home/denis/TestDicom/mcao31a.pc1-exam_fabien/6/acqp");
   acqp1.LoadFile(file2Read1);
   reco1.LoadFile(file2Read2);
   std::cout << "=============== acqp1 FillMap =================" << std::endl;
   acqp1.FillMap();
   acqp1.PrintSelf();
   std::cout << "=============== End acqp1 FillMap =================" << std::endl;
   std::cout << "=============== reco1 FillMap =================" << std::endl;
   reco1.FillMap();
   reco1.PrintSelf();
   std::cout << "=============== End reco1 FillMap =================" << std::endl;



   std::cout << "=============== BuildLoopStructure =================" << std::endl;
   
// LoopStructure is used to control the way the loops can be unrolled (in ObjectsLineList)
   acqp1.SetLoopStructure();
   std::vector<int> TempVect = acqp1.GetLoopStructure() ;
   for(int i=0;i<TempVect.size();i++){
      std::cout<<"GenericLoopStructure["<<i<<"]="<<TempVect[i]<<std::endl;
   }
   std::cout << "=============== End BuildLoopStructure =================" << std::endl;

   std::cout << "=============== SetBrukerObjectsLineStructure =================" << std::endl;

// ObjectsLineList is a matrix containing for each line acquired which was its position in the acquisition loop
// This position do not take into account an eventual slice interleaved acquisition

   acqp1.SetBrukerObjectsLineList();
   std::vector<std::vector<int> > TempMat=acqp1.GetBrukerObjectsLineList();
   std::map<std::string, BrukerFieldData> Map=acqp1.GetBrukerHeaderMap();
   
//ObjectVaryingProperties is a method centralizing the access to "all" the varying properties of images like position, orientation, echo time, .....
//It needs the BrukerHeaderMap and the LoopStructure as input

   bool result=acqp1.ObjectVaryingProperties.init(Map,TempVect);
   int  Reordered,i,j,k,l;
   std::vector<std::vector<double> > TempMat2;
   for(int i=0;i<TempMat.size();i++){
      std::cout<<std::endl<<"["<<i<<"] ";
      for (int j=0;j<TempMat[0].size();j++)  
         std::cout<< "["<<TempMat[i][j]<<"] ";
// fugly trick but sofar the eventual interleaved information applies to the slice loop =>BrukerObjectsLineList[*][2]
      Reordered=acqp1.ObjectVaryingProperties.getAcquisitionOrder(TempMat[i][2]);
      std::cout<<" TE = "<<acqp1.ObjectVaryingProperties.getTE(TempMat[i][0]);
// And the Reordering applies to values "constructed" exterior to the slice loop (ie : BrukerObjectsLineList[*][>=2])
      std::cout<<"   [R,P,S]xyz = ["<<acqp1.ObjectVaryingProperties.getPositionR(Reordered);
      std::cout<<" , "<<acqp1.ObjectVaryingProperties.getPositionP(Reordered);
      std::cout<<" , "<<acqp1.ObjectVaryingProperties.getPositionS(Reordered)<<"]  ";
      TempMat2=acqp1.ObjectVaryingProperties.getOrientation(Reordered);
      std::cout<<"   [R,P,S]orient = [";
      for (k=0;k<=2;k++){ 
         std::cout << "[";
         for (l=0;l<=2;l++) std::cout<< TempMat2[k][l]<<"  ";
            std::cout<<"]";
      }
      std::cout<<"]";
      std::cout<<"    Slice Number = "<<Reordered<<"  ";
      std::cout<<" TimePositionPerNR = "<<acqp1.ObjectVaryingProperties.getPositionTimePerNR(TempMat[i].back());
   }
   std::cout<<std::endl;
   std::cout << "=============== End SetBrukerObjectsLineStructure =================" << std::endl;

//Same routine as above but instead of scruting the loop structure of raw data
//we deal with an image structure so the loops used to construct an image do not appear anymore 
//but apparently the interleaveness stand still

   std::cout << "=============== Begin BrukerImageStructure=================" << std::endl;
   acqp1.SetImageLoopStructure();
   acqp1.SetBrukerImageList();
   std::vector<std::vector<int> > BrukerImageList=acqp1.GetBrukerImageList();
   std::vector<std::vector<double> > BrukerImageList2;
   for(int i=0;i<BrukerImageList.size();i++){
      std::cout<<std::endl<<"["<<i<<"] ";
      for (int j=0;j<BrukerImageList[0].size();j++)  
         std::cout<< "["<<BrukerImageList[i][j]<<"] ";
      Reordered=acqp1.ObjectVaryingProperties.getAcquisitionOrder(BrukerImageList[i][2]);
      std::cout<<" TE = "<<acqp1.ObjectVaryingProperties.getTE(BrukerImageList[i][0]);
      std::cout<<"   [R,P,S]xyz = ["<<acqp1.ObjectVaryingProperties.getPositionR(Reordered);
      std::cout<<" , "<<acqp1.ObjectVaryingProperties.getPositionP(Reordered);
      std::cout<<" , "<<acqp1.ObjectVaryingProperties.getPositionS(Reordered)<<"]  ";
      BrukerImageList2=acqp1.ObjectVaryingProperties.getOrientation(Reordered);
      std::cout<<"   [R,P,S]orient = [";
      for (k=0;k<=2;k++){ 
         std::cout << "[";
         for (l=0;l<=2;l++) 
	    std::cout<< BrukerImageList2[k][l]<<"  ";
         std::cout<<"]";
      }
      std::cout<<"]";
      std::cout<<"    Slice Number = "<<Reordered<<"  ";
      std::cout<<" TimePositionPerNR = "<<acqp1.ObjectVaryingProperties.getPositionTimePerNR(BrukerImageList[i].back());
   }
   std::cout<<std::endl;
   std::cout << "=============== End  BrukerImageStructure=============" << std::endl;


   BrukerImage Image(acqp1,reco1);
   Image.Init(acqp1,reco1,1);
   std::vector<BrukerImage> ImageSet;

   for(int i=0;i<BrukerImageList.size();i++){
      Image.Init(acqp1,reco1,i);
      ImageSet.push_back(Image);
   };

   std::string fid("/home/denis/TestDicom/kiwidicom.QZ1/3/fid");
   std::cout << "=============== Getkspace =================" << std::endl;
   acqp1.Getkspace(fid); 
   std::cout << "=============== End Getkspace =================" << std::endl;
   return EXIT_SUCCESS;
}
