/*=========================================================================
                                                                                
  Program:   gdcm
  Module:    $RCSfile: testBruker2Dicom.cxx,v $
  Language:  C++
  Date:      $Date: 2010/03/03 11:07:58 $
  Version:   $Revision: 1.9 $
                                                                                
  Copyright (c) CREATIS (Centre de Recherche et d'Applications en Traitement de
  l'Image). All rights reserved. See Doc/License.txt or
  http://www.creatis.insa-lyon.fr/Public/Gdcm/License.html for details.
                                                                                
     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.
                                      
=========================================================================*/

/**
 * Transform private Bruker tree structure
 * into the equivalent, with DICOM files *and/or* MHD files. 
 * 
 */
#include "bruker2dicom.h"

#include "gdcmCommon.h"
#include "gdcmDebug.h"
#include "gdcmUtil.h"
#include "gdcmDirList.h"

#include "gdcmArgMgr.h"

#include "bruker2dicom.h"
#include "brukerexception.h"

// ===================================================================================================
/**
  * \brief
  *          - explores  the given root directory e.g. :
  *            B67d1.Bp1
  *              subject
  *              AdjStatePerStudy
  *              1
  *                 acqp
  *                 AdjStatePerScan
  *                 fid
  *                 imnd / method
  *                 pulseprogram
  *                 spnam0
  *                 spnam1
  *                 pdata
  *                    1		// only 'native' images
  *                       2dseq
  *                       d3proc
  *                       meta
  *                       procs
  *                       reco  <--
  *                       roi
  *                       CreatisComputedCartoFile
  *                    2		// post processed images (if any)
  *                       2dseq
  *                       d3proc
  *                       isa  <--
  *                       meta
  *                       procs
  *                       roi                      ...
  *                       roi
  *                    3		// post processed images (if any)
  *                       2dseq
  *                       d3proc
  *                       isa  <--
  *                       meta
  *                       procs
  *                       roi
  *                    ...
  *              2
  *                 acqp
  *                 fid
  *                 ...
  *                 pdata
  *              3
  *                ...
  *          - fills a single level Directory with the MHD files,
  */


int main(int argc, char *argv[])
{
   START_USAGE(usage)
   " \n testBruker2Dicom : \n                                                 ",
   " - explores the given directory (holding a FULL Bruker exam), at the 3 levels,",
   " - fills an equivalent Directory with the MHD files and/or the DICOM files",
   " usage: testBruker2Dicom --dirin=rootDirectoryName                          ",
   "                         --dirout=outputDirectoryName                       ",
   "                   [-D] [-M]                                                ",
   "                   [{-b|-l}] b:BigEndian,l:LittleEndian default : l         ",
   "                   [--debug] [--verbose] [--listonly] [--usage]           ",
   "                                                                          ",
   "   D         : user wants to export as DICOM                              ",
   "   M         : user wants to export as MHD                                ",   
   "  debug      : developper wants to run the program in 'debug mode'        ",
   "                                                                          ",   
   "  REMARK :                                                                ",   
   "         If you were supplied  an *incomplete* Bruker exam                ",
   "        (e.g. only the '2' serie) put it a 'root' directory,              ",
   "         and run this test using this 'root' directory as 'dirin'         ",   
   FINISH_USAGE
   
   // ------------ Initialize Arguments Manager ----------------  
   GDCM_NAME_SPACE::ArgMgr *am= new GDCM_NAME_SPACE::ArgMgr(argc, argv);
  
   if (argc == 1 || am->ArgMgrDefined("--usage") )
   {
      am->ArgMgrUsage(usage); // Display 'usage'
      delete am;
      return 1;
   }

   // create the devilish object!
   Bruker2Dicom b2d;
      
   const char *dirNamein;   
   dirNamein  = am->ArgMgrGetString("--dirin",".");

   const char *dirNameout;   
   dirNameout  = am->ArgMgrGetString("--dirout",".");

// note : Big Endian / Little Endian pb not yet dealt with.
//        not a great issue, since everybody (?) works on Intell procs  
   int b = am->ArgMgrDefined("-b");
   int l = am->ArgMgrDefined("-l");

   if (am->ArgMgrDefined("--debug"))
      GDCM_NAME_SPACE::Debug::DebugOn();

   b2d.verbose  = am->ArgMgrDefined("--verbose");      
   int listonly = am->ArgMgrDefined("--listonly");
   
   int dicom    = am->ArgMgrDefined("-D");
   int mhd      = am->ArgMgrDefined("-M");
   
   if (dicom)
      b2d.SetConvertModeToDicom();
   if (mhd)
      b2d.SetConvertModeToMhd();

   /* if unused Param we give up */
   if ( am->ArgMgrPrintUnusedLabels() )
   {
      am->ArgMgrUsage(usage);
      delete am;
      return 1;
   } 

// patientName : found in Bruker parameter files
// patientName  = am->ArgMgrGetString("patientname", "Patient^Name");

// b2d.day : unused  ...
   b2d.day          = am->ArgMgrGetString("day", "You_forget_the_Day");

 delete am;  // we don't need Argument Manager any longer

   // ----------- End Arguments Manager ---------
   

   // ----- Begin Processing -----

   b2d.SetInputDirectory(dirNamein);
   b2d.SetOutputDirectory(dirNameout);

   /// \TODO : *do* use exceptions in the methods!

   try {
      b2d.Execute();
   }
   catch (int i)
   {
      std::cout << "Exception was thrown  (" << i << ") " << std::endl;
   }
   /*
   catch (std::exception& e) {
   std::cerr << "ERREUR: " << e.what() << "expected length: " << e.getExpectedLgt()
             << " Found : " << e.getFoundLgt() << std::endl;
   }
  */

   catch (BrukerHopelessException &e)
   {
      std::cout << "And Hopless Exception was thrown  (" << e.what() << ") " << std::endl;
   }


}


