#include "bruker2dicom.h"
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include "brukerexception.h"

#ifndef PATH_MAX // If not defined yet : do it 
   #define PATH_MAX 2048
#endif 

bool Bruker2Dicom::Execute()
{
   // ----- Check input directory name -----

   bool bigEndian = GDCM_NAME_SPACE::Util::IsCurrentProcessorBigEndian();
 
   //if ( ! GDCM_NAME_SPACE::DirList::IsDirectory(InputDirName) )
   if ( ! boost::filesystem::is_directory(InputDirName) )
   {
      std::cout << "KO : [" << InputDirName << "] is not a Directory." << std::endl;
      return 0;
   }
   else
   {
      if (verbose)
         std::cout << "OK : [" << InputDirName << "] is a Directory." << std::endl;
   }

   // ----- Check output directory name -----

   std::string strDirNameOut(OutputDirName); 
   bool res=CreateDirectory(strDirNameOut);
   if (!res) {
      std::cout << "[" << OutputDirName << "] Directory creation failure " << std::endl;
      //exit (0);
      throw ( BrukerHopelessException ("Output directory creation failure "));
   }

   std::string strDirNamein(InputDirName);
   GDCM_NAME_SPACE::DirList dirList(strDirNamein, false, true); // DON'T get recursively the list of files
   std::string strDirNameout(OutputDirName);   

/*
   if (listonly)
   {
      std::cout << "------------List of found files ------------" << std::endl;
      dirList.Print();
      std::cout << std::endl;
      return 1;
   }
*/

//
// e.g : at level 0, in : B67d1.Bp1
//
//           1  2  3  4  5  6  AdjStatePerStudy  subject
//

   GDCM_NAME_SPACE::DirListType fileNames;
   fileNames = dirList.GetFilenames();
   bool canOpen;
   std::string outputFileName;

  // BrukerDataSet br_subject;
   std::string subject;
   subject = GDCM_NAME_SPACE::Util::GetPath(*(fileNames.begin()))+
             GDCM_NAME_SPACE::GDCM_FILESEPARATOR +
             "subject";
   if (verbose)
        std::cout << " Subject : [" <<  subject << "]" << std::endl;
	
   bool subjectFound;  
   canOpen =br_subject.LoadFile(subject);  
   if (!canOpen)
   {
      //std::cout << "Hopeless! no 'subject' found" << std::endl;
      //throw ( BrukerHopelessException ("Hopeless! no 'subject' found in root input directory "));
       
      std::cout << "Not too much hope! no 'subject' found (Desperate try will be performed -default values- )" << std::endl;
      subjectFound = false;
   }
   else
   { 
      br_subject.FillMap();
      subjectFound = true;   
   }
   //br_subject.PrintSelf();

  // get info for 'Study Description'  

    if (subjectFound)
    {
       BrukerFieldData b_name=br_subject.GetFieldData("SUBJECT_name_string");
       subject_name = b_name.GetStringValue()[0];
       strPatientName = subject_name;
       cleanString(subject_name);
     }
     else
        subject_name ="defaultPatName";  
	 
    // creation directory : 'nom du patient'
    std::string tempStringPatDir(OutputDirName);
    tempStringPatDir = tempStringPatDir + GDCM_NAME_SPACE::GDCM_FILESEPARATOR + subject_name;
	 
    res=CreateDirectory(tempStringPatDir);
    if (!res) {
       std::cout << "[" << tempStringPatDir << "] Directory creation failure " << std::endl;
       throw ( BrukerHopelessException ("Patient directory creation failure "));
    }	  

    std::string subject_entry;
    std::string subject_position;
    std::string subject_date;
    std::string subject_study_name;
 
    if (subjectFound)
    {
       BrukerFieldData b_entry=br_subject.GetFieldData("SUBJECT_entry");
       subject_entry = b_entry.GetStringValue()[0];
       //cleanString(subject_entry);
       subject_entry = subject_entry.substr(11, subject_entry.size()-11);
  
       BrukerFieldData b_position=br_subject.GetFieldData("SUBJECT_position");
       subject_position = b_position.GetStringValue()[0];
       //cleanString(subject_position);
       subject_position = subject_position.substr(9, subject_position.size()-9);
 
       BrukerFieldData b_date=br_subject.GetFieldData("SUBJECT_date");
       subject_date = b_date.GetStringValue()[0];
       strStudyTimeDate = subject_date;
       cleanString(subject_date);
 
       BrukerFieldData b_study_name=br_subject.GetFieldData("SUBJECT_study_name");
       subject_study_name = b_study_name.GetStringValue()[0];
       subject_study_name = subject_study_name.substr(1, subject_study_name.size()-2);
       cleanString(subject_study_name);
   }
   else  // Desperate trick when file 'subject' is missing
   {
      subject_entry      = "HeadFirst";            // Why not?
      subject_position   = "Supine";               // Why not?
      strStudyTimeDate   = "06_06_06_6_June_1666"; // Why not?
      subject_date       = "6_June_1666";          // Why not?
      subject_study_name = "defStudyName";         // Why not? 
   }
    // subject_name is already in 'Patient Name' 
    strStudyDescr = /*subject_name + "." + */ subject_study_name + "." + subject_entry + "." + subject_position + "." + subject_date;
   
    // creation directory : 'nom de la Study'
    
    std::string tempStringStudyDir(OutputDirName);
    tempStringStudyDir = tempStringPatDir + GDCM_NAME_SPACE::GDCM_FILESEPARATOR + strStudyDescr;
	 
    res=CreateDirectory(tempStringStudyDir);
    if (!res) {
       std::cout << "[" << tempStringStudyDir << "] Directory creation failure " << std::endl;
       throw ( BrukerHopelessException ("Study directory creation failure "));
    }	  
   
   char outputDirName[(unsigned int) PATH_MAX+2];

   strStudyUID    = GDCM_NAME_SPACE::Util::CreateUniqueUID();
   serieNumber    = 0;
   instanceNumber = 0;

   // -----------------------------------------------------
   // Iterate to ALL the objets(files/directories) found in the input directory
   // (this is level ZERO)
   // each Directory (name : 1, 2, 3, ...) will be a Dicom Serie
   // -----------------------------------------------------
 
   GDCM_NAME_SPACE::DirListType::iterator it;

   for (it = fileNames.begin();
         it != fileNames.end();
       ++it)
   {
      if ( boost::filesystem::is_directory(*it) )
      { 
         if (verbose)
            std::cout << "[" << *it << "] is a directory" << std::endl;

         //BrukerDataSet br_acqp;
         std::string strAcqp;
         strAcqp = (*it) +
                   GDCM_NAME_SPACE::GDCM_FILESEPARATOR +
                   "acqp";

         br_acqp.LoadFile(strAcqp);
         br_acqp.FillMap();

//std::cout << "out of br_acqp.FillMap " << std::endl;
         std::string acqp_scan_name;
         std::string acqp_method;
         std::string acqp_protocol_location; 
 
         BrukerFieldData b_protocol_location=br_acqp.GetFieldData("ACQ_protocol_location");
         acqp_protocol_location = b_protocol_location.GetStringValue()[0];
         cleanString(acqp_protocol_location);

//std::cout << "out of br_acqp.FillMap 1" << std::endl;    
         BrukerFieldData b_scan_name=br_acqp.GetFieldData("ACQ_scan_name");
//std::cout << "out of br_acqp.FillMap 11" << std::endl;	 
         acqp_scan_name = b_scan_name.GetStringValue()[0];
//std::cout << "out of br_acqp.FillMap 12 [" << acqp_scan_name << "]" << std::endl;	 
         cleanString(acqp_scan_name);
//std::cout << "out of br_acqp.FillMap 2" << std::endl;  
         BrukerFieldData b_method=br_acqp.GetFieldData("ACQ_method");
	 b_method.PrintSelf();
         acqp_method = b_method.GetStringValue()[0];
  
         cleanString(acqp_method);
//std::cout << "out of br_acqp.FillMap 3" << std::endl;
         BrukerFieldData b_list_size = br_acqp.GetFieldData("ACQ_O1_list_size");
//std::cout << "out of br_acqp.FillMap 4" << std::endl;        
	 //b_list_size.PrintSelf(); //JP
 
         nbSlices =  b_list_size.GetIntValue()[0];
//std::cout << "out of br_acqp.FillMap 5" << std::endl;
         strSerieDescr = GDCM_NAME_SPACE::Util::GetName(*it)
                       /*  + "." + acqp_protocol_location */ // always the same (in each acquisition)
                         + "." + acqp_scan_name
                         + "." + acqp_method.c_str();

         sprintf(outputDirName, "%s%c%s", tempStringStudyDir.c_str(),                //OutputDirName.c_str(), 
                          GDCM_NAME_SPACE::GDCM_FILESEPARATOR,
                          strSerieDescr.c_str() );
  
         std::cout << " ================================================================================\n"
                   << " === [" << GDCM_NAME_SPACE::Util::GetName(*it) << "] -> [" << strSerieDescr << "]\n"
                   << " ================================================================================"
                   << std::endl;

        if (verbose)
           printf ("outputDirName [%s]\n", outputDirName);   
        try {
           DealWithNiveau1(*it, outputDirName);
	}
	catch (BrukerHopelessException &e)
	{
	 std::cout << "And Exception was thrown in DealWithNiveau1 (" << e.what() << ") " << std::endl;
	 continue;
	}
      }
   } // end of : for (GDCM_NAME_SPACE::DirListType::iterator it
}

// =====================================================================

void Bruker2Dicom::DealWithNiveau1(std::string level1Directory, std::string currentOutputDirName) {
//
// e.g. : at level 1, in B67d1.Bp1/6
//
// acqp  fid  imnd  pdata  pulseprogram  spnam0  spnam1

   bool res = CreateDirectory(currentOutputDirName); 

   if (!res) {
      std::cout << "[" << currentOutputDirName << "] Directory creation failure " << std::endl;
      throw ( BrukerHopelessException ("Level 1 output directory creation failure "));    
     // exit (0);
   }
   GDCM_NAME_SPACE::DirList dirList(level1Directory, false, true); // DON'T get recursively the list of files
   GDCM_NAME_SPACE::DirListType fileNames;
   fileNames = dirList.GetFilenames();
   // -----------------------------------------------------
   // Iterate to ALL the objets(files/directories) found in the input directory
   // -----------------------------------------------------
   GDCM_NAME_SPACE::DirListType::iterator it;

   for (it = fileNames.begin();
        it != fileNames.end();
      ++it)
   {
      if ( boost::filesystem::is_regular(*it) ) 
      //if ( ! boost::filesystem::is_directory(*it) )
      {
         if (verbose)
            std::cout << "--- [" << *it << "] is a file." << std::endl;
      }  
   }

   char outputDirName[(unsigned int) PATH_MAX+2];
   //std::string firstName;
   bool canOpen;
   for (it = fileNames.begin();
        it != fileNames.end();
      ++it)
   {
      if ( boost::filesystem::is_directory(*it) )
      {
         // will be always "pdata" ...
         if (verbose)
            std::cout << "--- [" << *it << "] is a directory" << std::endl;

              /* a recuperer :
              if (FileLine.startsWith("##$ACQ_size=")) {
              if (FileLine.startsWith("##$NI=")) {
              if (FileLine.startsWith("##$NR=")) {
              if (FileLine.startsWith("##$ACQ_obj_order=")) {
              if (FileLine.startsWith("##$ACQ_word_size=")) {
              if (FileLine.startsWith("##$BYTORDA=")) {
              if (FileLine.startsWith("##$PULPROG=")) {
              */

         sprintf(outputDirName, "%s%c%s", currentOutputDirName.c_str(),
                                          GDCM_NAME_SPACE::GDCM_FILESEPARATOR,
                                          GDCM_NAME_SPACE::Util::GetName(*it).c_str());
         //br1.PrintSelf();

          std::string strMethod;
          //std::string firstName = *(fileNames.begin());

          strMethod = GDCM_NAME_SPACE::Util::GetPath(*(fileNames.begin())) +
                      GDCM_NAME_SPACE::GDCM_FILESEPARATOR +
                      "method";
            // std::cout << "---strMethod (for method)=> [" << strMethod << "]" << std::endl;        
          canOpen = br_method.LoadFile(strMethod);
          if (!canOpen)
          {
             strMethod = GDCM_NAME_SPACE::Util::GetPath(*(fileNames.begin()))+
                         GDCM_NAME_SPACE::GDCM_FILESEPARATOR +
                         "imnd";
             //std::cout << "---strMethod (for imnd) => [" << strMethod << "]" << std::endl;
             canOpen = br_method.LoadFile(strMethod);
             if (!canOpen)
             {
                std::cout << "Hopeless! neither 'method' nor 'imnd' found in ["
		          << level1Directory  << "]; we skip it!" << std::endl;
		continue;
                //throw ( BrukerHopelessException ("Hopeless! neither 'method' nor 'imnd' found "));		
                //exit(0);  /// \TODO throw an exception !
             }
          }
          if (verbose)
             std::cout << "open => [" << strMethod << "] successfully" << std::endl; 
          br_method.FillMap();

          /* a recuperer :
             ##$PVM_Fov (dimension)  // ou plutot RECO_fov !
          */
  /*
          dans method (pour perfusion  seulement?) :
          ##$PVM_ObjOrderList=( 8 )
          0 2 4 6 1 3 5 7
          ##$PVM_NSPacks=2
          ##$PVM_SPackArrNSlices=( 2 )
          7 1  
  */    
         try {
            DealWithNiveau2(*it, outputDirName);
	 }
	 catch (BrukerHopelessException &e)
	 {
	    std::cout << "And Exception was thrown in DealWithNiveau2 (" << e.what() << ") " << std::endl;
	    continue;
	 }
      }
   }
}

// =====================================================================

void Bruker2Dicom::DealWithNiveau2(std::string level2Directory, std::string currentOutputDirName) {

// e.g. : at level 2 in B67d1.Bp1/6/pdata
//
// acqp  fid  imnd  pdata  pulseprogram  spnam0  spnam1
//

   bool res = CreateDirectory(currentOutputDirName); 

   if (!res) {
      std::cout << "[" << currentOutputDirName << "] Directory creation failure " << std::endl;
      throw ( BrukerHopelessException ("Hopeless! Level2 output directory creation failure"));	      
      //exit (0);
   }

   GDCM_NAME_SPACE::DirList dirList(level2Directory, false, true); // DON'T get recursively the list of files

   GDCM_NAME_SPACE::DirListType fileNames;
   fileNames = dirList.GetFilenames();

   char outputDirName[(unsigned int) PATH_MAX+2];

   // -----------------------------------------------------
   // Iterate to ALL the objets(files/directories) found in the input directory
   // -----------------------------------------------------
   GDCM_NAME_SPACE::DirListType::iterator it;
   bool canOpen;

   if (verbose)
   for (it = fileNames.begin();
        it != fileNames.end();
      ++it)
   {
      if ( ! boost::filesystem::is_directory(*it) )
      { 
         std::cout << "--- --- [" << *it << "] is a file.." << std::endl;
      }
   }
  
   for (it = fileNames.begin();
         it != fileNames.end();
       ++it)
   {
      if ( boost::filesystem::is_directory(*it) )
      { 
  
         if (verbose)
            std::cout << "--- --- [" << *it << "] is a directory" << std::endl;

        // sprintf(outputDirName, "%s%c%s", currentOutputDirName.c_str(), 
        //                          GDCM_NAME_SPACE::GDCM_FILESEPARATOR,
        //                                GDCM_NAME_SPACE::Util::GetName(*it).c_str() );
  // MUST be 'pdata'!

//
// (interest of previous method :
// If unaware user changed the pdata name, it goes on working   
//
          std::string str_isa;
          str_isa = (*it) + 
                    GDCM_NAME_SPACE::GDCM_FILESEPARATOR +
                   "isa";

          std::string str_isa_func_name;    
          canOpen = br_isa.LoadFile(str_isa);
          if (!canOpen)
          {
             sprintf(outputDirName, "%s%c%s", currentOutputDirName.c_str(), 
                                          GDCM_NAME_SPACE::GDCM_FILESEPARATOR,
                                          GDCM_NAME_SPACE::Util::GetName(*it).c_str() );        
          }
          else
          {
             br_isa.FillMap();
             BrukerFieldData b_isa_func_name = br_isa.GetFieldData("ISA_func_name");
    
             str_isa_func_name = b_isa_func_name.GetStringValue()[0];
             cleanString(str_isa_func_name);

             sprintf(outputDirName, "%s%c%s.%s", currentOutputDirName.c_str(), 
                                          GDCM_NAME_SPACE::GDCM_FILESEPARATOR,
                                          GDCM_NAME_SPACE::Util::GetName(*it).c_str(),
             str_isa_func_name.c_str());
          }
	  try {
             DealWithNiveau3(*it, outputDirName);
	  }
	  catch (BrukerHopelessException &e)
	  {
	     std::cout << "And Exception was thrown in DealWithNiveau3 (" << e.what() << "); " 
	               << " We skip [" << level2Directory << "]" << std::endl;
	     continue;
	  }
	  catch (BrukerInitException &e)
	  {
	     std::cout << "And Init Exception was thrown in DealWithNiveau3 (" << e.what() << "); " 
	               << " We skip [" << level2Directory << "]" << std::endl;
	     continue;
	  }	     
      }
   }
}

//
// =====================================================================
//

void Bruker2Dicom::DealWithNiveau3(std::string level3Directory, std::string currentOutputDirName){

//
// e.g. at level 3, in

   // just to be able to go on checking // JP
   if ( GDCM_NAME_SPACE::Util::GetName(level3Directory) != "1")
      return;

   bool res = CreateDirectory(currentOutputDirName);

   if (!res)
   {
      std::cout << "[" << currentOutputDirName << "] Directory creation failure " << std::endl;
      throw ( BrukerHopelessException ("Hopeless! Level3 output directory creation failure"));
      //exit (0);
   }

   GDCM_NAME_SPACE::DirList dirList(level3Directory, false, true); // DON'T get recursively the list of files
   GDCM_NAME_SPACE::DirListType::iterator it;
   GDCM_NAME_SPACE::DirListType fileNames;
   fileNames = dirList.GetFilenames();

   char original2dseqName       [(unsigned int) PATH_MAX+2];
   char original2dseqName_XXX   [(unsigned int) PATH_MAX+2];   
   char currentOutputMhdDirName [(unsigned int) PATH_MAX+2];

   char outputMhdFileName       [(unsigned int) PATH_MAX+2];
   char output2dseqSliceFileName[(unsigned int) PATH_MAX+6]; // think about extra '.dcm'
   char output2dseqName         [(unsigned int) PATH_MAX+6];
   char output2dseqCartoName    [(unsigned int) PATH_MAX+6];

   char copyFile[PATH_MAX + PATH_MAX + 5]; // Should be enough!
   bool canOpen;

   //-------------- try d3proc;
   char char_d3proc[(unsigned int) PATH_MAX+2];

   sprintf(char_d3proc,"%s%c%s", level3Directory.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR,"d3proc" );     

   if (verbose)
      std::cout << "d3proc: --- => [" << char_d3proc << "]" << std::endl;
   std::string str_d3proc(char_d3proc);       
   canOpen = br_d3proc.LoadFile(str_d3proc);

   if (!canOpen)
   {
      std::cout << "Hopeless! no 'd3proc' found" << std::endl;
      throw ( BrukerHopelessException ("Hopeless! no 'd3proc' found"));
      //exit(0);  /// \TODO throw an exception ! 
   }

   canOpen = br_d3proc.FillMap();
   if (!canOpen)
   {
      std::cout << "Hopeless! FillMap failed on 'd3proc'" << std::endl;
      throw ( BrukerHopelessException ("Hopeless! FillMap failed on 'd3proc'"));      
      //exit(0);  /// \TODO throw an exception !     
   }

   //-------------- end try d3proc;


 // -------------------try reco

   char char_reco[(unsigned int) PATH_MAX+2];

   sprintf(char_reco,"%s%c%s", level3Directory.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR,"reco" );     
    //str_d3proc = GDCM_NAME_SPACE::Util::GetPath(*(fileNames.begin()))+
    //             GDCM_NAME_SPACE::GDCM_FILESEPARATOR +
    //             "d3proc";
   if (verbose)
      std::cout << "reco: --- => [" << char_reco << "]" << std::endl;
      
   std::string str_reco(char_reco);
   canOpen = br_reco.LoadFile(str_reco);

   if (!canOpen) // we try in directory ../1
   {
      if (verbose)
         std::cout << "[" << str_reco << "] not found " << std::endl;
      std::string lastDirName = GDCM_NAME_SPACE::Util::GetPath(level3Directory);
      //lastDirName = GDCM_NAME_SPACE::Util::GetPath(lastDirName);
      sprintf(char_reco,"%s%c1%c%s", lastDirName.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR,GDCM_NAME_SPACE::GDCM_FILESEPARATOR,"reco" );
      //str_reco=char_reco;
      canOpen = br_reco.LoadFile(str_reco);
      if (!canOpen)
      {
         std::cout << "Hopeless! cannot find 'reco' in [" << str_reco << "]"  << std::endl;	 
         throw ( BrukerHopelessException ("Hopeless! cannot find 'reco'"));  
         //exit(0);  /// \TODO throw an exception !    
      }
   } else {
      if (verbose)
         std::cout << "[" << str_reco << "] successfully Loaded " << std::endl;
   }
   
   canOpen = br_reco.FillMap();
   if (!canOpen)
   {
      std::cout << "Hopeless! FillMap failed on [" << str_reco << "]" << std::endl;
      throw ( BrukerHopelessException ("Hopeless! FillMap failed on 'reco'"));  
      //exit(0);  /// \TODO throw an exception !
   } else {
      if (verbose)
         std::cout << "[" << str_reco << "] successfully Mapped" << std::endl;
   }   
   
   //std::cout << "------------------------------------------------------------------------------------------------" << std::cout;
   // br_reco.PrintSelf();
   // std::cout << "------------------------------------------------------------------------------------------------" << std::cout;
   // -------------------end try reco


   BrukerFieldData bX = br_d3proc.GetFieldData("IM_SIX");
   int NX = bX.GetIntValue()[0];

   if (verbose)
      std::cout << "IM_SIX " << NX << std::endl;
   BrukerFieldData bY=br_d3proc.GetFieldData("IM_SIY"); 
   int NY = bY.GetIntValue()[0];

   if (verbose)
         std::cout << "IM_SIY " << NY << std::endl;
   /// \todo : check if there are actually 3 dimensions or only 2

   BrukerFieldData bZ= br_d3proc.GetFieldData("IM_SIZ");
   int nbFrames = bZ.GetIntValue()[0]; 
   if (verbose)
         std::cout << "IM_SIZ " << nbFrames << std::endl;

        // WARNING DATTYPE is, either in {ip_short, ip_int, ip_char, ...}, or in {1, 2, 3, ...}

   BrukerFieldData bDPT = br_d3proc.GetFieldData("DATTYPE");

   std::string mhdDataPixelType;
   int pixelSize;
   getImhDataType(bDPT, mhdDataPixelType, pixelSize);


 /*

 // See mail Denis : 
 // En regle generale il vaut mieux que l'on passe par RECO_* 
 // pour extraire les parametres de l'image
 //

   BrukerFieldData fov = br_method.GetFieldData("PVM_Fov");
   double fovX = fov.GetDoubleValue()[0];
   double fovY = fov.GetDoubleValue()[1];
   if (verbose)
      std::cout << "FOV (ds method) " << fovX << " " << fovY << std::endl;

   BrukerFieldData spatResol = br_method.GetFieldData("PVM_SpatResol");
   double spatResolX = spatResol.GetDoubleValue()[0];
   double spatResolY = spatResol.GetDoubleValue()[1];
   if (verbose)
      std::cout << "SpatResol (ds method) " << spatResolX << " " << spatResolY << std::endl;
          
*/

/* ------  */
// Better we use 'get' accessors from BrukerImage class, as Denis wrote them

   BrukerFieldData fov = br_reco.GetFieldData("RECO_fov");
   double fovX = fov.GetDoubleValue()[0];
   double fovY = fov.GetDoubleValue()[1];
   if (verbose)
      std::cout << "FOV (ds reco) " << fovX << " " << fovY << std::endl;

   BrukerFieldData size = br_reco.GetFieldData("RECO_size");
   double sizeX = size.GetDoubleValue()[0];
   double sizeY = size.GetDoubleValue()[1];
   
   if (verbose)
      std::cout << "SIZE (ds reco) " << sizeX << " " << sizeY << std::endl;
       
   double spatResolX = fovX / sizeX;
   double spatResolY = fovY / sizeY;
       
   if (verbose)
      std::cout << "spatResol (ds reco : fov/size) " << spatResolX << " " << spatResolY << std::endl;

/* ------  */

   /// \TODO probabely a more sophisticated accessor will be necessary :
   ///  (cf : non contiguous slices, overlapping, slice thickness, space between slices, etc)
   
   BrukerFieldData bsliceDistance = br_method.GetFieldData("PVM_SPackArrSliceDistance");
   double sliceDistance = bsliceDistance.GetDoubleValue()[0];
   
   if (verbose)
      std::cout << "SPackArrSliceDistance (ds method) " << sliceDistance << std::endl;   

// ----------------------------------------------------------------------------------------

   if (mhd)
   {
      sprintf(currentOutputMhdDirName, "%s%c%s", currentOutputDirName.c_str(),
                               GDCM_NAME_SPACE::GDCM_FILESEPARATOR, "MhdFiles");
      res = CreateDirectory( currentOutputMhdDirName );
      if (!res) {
         std::cout << "[" << currentOutputDirName << "] Directory creation failure " << std::endl;
	 throw ( BrukerHopelessException ("Hopeless!FillMap failed on 'reco'"));  
         //exit (0);
      } 

      if (verbose)
         std::cout << "Directory creation [" <<  currentOutputDirName << "]" << std::endl;
   }  // end if mhd

   if (verbose)
         std::cout << "nbFrames " << nbFrames << std::endl;
   if (verbose)
         std::cout << "nbSlices " << nbSlices << std::endl;
   int k;
   int nbInstants = nbFrames/nbSlices;
   if (verbose)
         std::cout << "nbInstants (deduced)" << nbInstants << std::endl;    
   int instantNb;
   int sliceNb; 
   FILE *fp;  // for MHD files

   sprintf( original2dseqName, "%s%c%s", level3Directory.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR, "2dseq");

/**/   
  // \TODO : tenir compte du bazar precedent 

    // load 2dseq in memory

   fp = fopen(original2dseqName, "rb");
   if (!fp) 
   {
      // try 2dseq_Angio2D ?!?

      sprintf( original2dseqName_XXX, "%s%s", original2dseqName, "_Angio2D");
      fp = fopen(original2dseqName_XXX, "rb");
      if (!fp)
      {
         std::cout << "Cannot open [" << original2dseqName << "] nor [" <<  original2dseqName_XXX << "] for reading" << std::endl;
         fclose(fp);	 
         throw ( BrukerHopelessException ("Hopeless! Cannot open '2dseq'"));
         //exit (0);
      }
   }

   unsigned char *buffer_2dseq = new unsigned char[NX*NY*pixelSize*nbSlices*nbInstants];   
   ///\ TODO : find a safer way to be sure to read everything!
   size_t lgr = fread(buffer_2dseq, 1, NX*NY*pixelSize*nbSlices*nbInstants, fp);

   // This one will be important!
   // ---------------------------
   try {
      imageSet = CreateImageSet ( );
   }
   catch (BrukerInitException& e)
   {
      if (verbose)
         std::cout <<  "an Init Exception was thrown in CreateImageSet ( ); " << e.what() 
                   <<  "catched in DealWithNiveau3" << std::endl;
      //return;
      throw (e);
   }

   serieNumber++;
   strSerieUID =  GDCM_NAME_SPACE::Util::CreateUniqueUID();
   if (nbInstants==1) // creer un seul fichier .mhd  pour toutes les Slices! (images natives)
   {
       if (verbose)
          std::cout << "Single instant : do not split" << std::endl;
       if (mhd)
       {
             sprintf(outputMhdFileName, "%s%cMhdData_All_the_Slices.mhd", currentOutputMhdDirName,
                                         GDCM_NAME_SPACE::GDCM_FILESEPARATOR);
             fp=fopen(outputMhdFileName, "w");
             if (!fp)
             {
                std::cout << "Cannot open [" << outputMhdFileName << "] for writting" << std::endl;
		throw ( BrukerHopelessException ("Hopeless! Cannot open  mhd file for writting"));
                //exit(0);
             }
             else
             {
               fprintf(fp, "ObjectType = Image\n");
               fprintf(fp, "NDims = 3\n" );
               fprintf(fp, "BinaryData = True \n" );
               fprintf(fp, "BinaryDataByteOrderMSB = False\n" );
               fprintf(fp, "DimSize = %d %d %d\n", NX, NY, nbSlices );
               fprintf(fp, "HeaderSize = %d\n", 0);
               //fprintf(fp, "ElementSpacing = %lf %lf %lf\n",fovX/NY, fovY/NY, sliceDistance );
	       fprintf(fp, "ElementSpacing = %lf %lf %lf\n", spatResolX, spatResolY, sliceDistance );
               fprintf(fp, "Position = 0 0 %d\n", 0 );
               fprintf(fp, "Offset = 0 0 0\n" );
               fprintf(fp, "CenterOfRotation = 0 0 0\n" );
               fprintf(fp, "ElementNumberOfChannels = 1\n" );
               fprintf(fp, "ElementType = %s\n", mhdDataPixelType.c_str() );  
               fprintf(fp, "ElementDataFile = %s\n", "../2dseq_All_the_Slices" );
               fclose(fp);     
             }
             sprintf(output2dseqSliceFileName, "%s%c2dseq_All_the_Slices", 
                                       currentOutputDirName.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR);
             fp=fopen(output2dseqSliceFileName, "wb");
             if (!fp)
             {
                std::cout << "Cannot open [" << output2dseqSliceFileName << "] for writting" << std::endl;
		throw ( BrukerHopelessException ("Hopeless! Cannot open 2dseq file for writting"));		
             }
             else
             {
                fwrite( buffer_2dseq, NX*NY*pixelSize, nbSlices, fp);     
             }
             fclose(fp);
             serieNumber ++;
             strSerieUID =  GDCM_NAME_SPACE::Util::CreateUniqueUID();
       }  // end if mhd
       if (dicom)
       {
             sprintf(output2dseqSliceFileName, "%s%c2dseq_All_the_Slices.dcm", 
                                       currentOutputDirName.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR);

            /* ----------- Write Dicom Image  ---------------*/
             MakeDicomImage(buffer_2dseq,
               NX,
               NY,
               nbFrames,
               pixelSize,
               //fovX/NY, fovY/NY, sliceDistance,
	       spatResolX, spatResolY, sliceDistance,
               output2dseqSliceFileName,
               subject_name,
               day,
               strStudyUID,
               strSerieUID,
               strStudyDescr,
               strSerieDescr,
               strStudyTimeDate,
               0,// index frame number
               GDCM_NAME_SPACE::UNMODIFIED_PIXELS_IMAGE
             );
       }  // end if dicom
   }  // end if nbInstants = 1

   else  // more than ONE instant
   {
          // Interleaved !
          // it's (slice1,slide2, ...)t1 ; (slice1,slide2, ...)t2 ; ...
         unsigned char *pixelsForCurrentSlice = new unsigned char[NX*NY*pixelSize*nbInstants];

         k = 0;
         for (sliceNb=0; sliceNb<nbSlices; sliceNb++)
         {
            if (mhd)
            {
               sprintf(outputMhdFileName, "%s%cMhdData_%03d.mhd", currentOutputMhdDirName, 
                                        GDCM_NAME_SPACE::GDCM_FILESEPARATOR, k  );
               if (verbose)
                  std::cout << "--- Output MHD file [" << outputMhdFileName << "]" << std::endl;
               fp=fopen(outputMhdFileName, "w");
               if (!fp)
               {
                   std::cout << "Cannot open [" << outputMhdFileName << "] for writting" << std::endl;
		   throw ( BrukerHopelessException ("Hopeless! Cannot open  mhd file for writting"));
                   //exit(0);
               }
               else
               {
            /* ----------- Write MHD Image  ---------------*/
                //if (verbose)
                //   std::cout << "Open sucessfully[" << outputMhdFileName << "] for writting" << std::endl; 
                   fprintf(fp, "ObjectType = Image\n");
                   fprintf(fp, "NDims = 3\n" );  
                   fprintf(fp, "BinaryData = True \n" );  
                   fprintf(fp, "BinaryDataByteOrderMSB = False\n" );    
                   fprintf(fp, "DimSize = %d %d %d\n", NX, NY, nbInstants);  
                   fprintf(fp, "HeaderSize = %d\n", 0); 
                   //fprintf(fp, "ElementSpacing = %lf %lf %lf\n",fovX/NY, fovY/NY, 1.0 ); // 
                   fprintf(fp, "ElementSpacing = %lf %lf %lf\n",spatResolX, spatResolY, 1.0 ); //slice distance : no meaning for temporal serie
		   fprintf(fp, "Position = 0 0 %d\n", sliceNb );  
                   fprintf(fp, "Offset = 0 0 0\n" );  
                   fprintf(fp, "CenterOfRotation = 0 0 0\n" );
                   fprintf(fp, "ElementNumberOfChannels = 1\n" );  
                   fprintf(fp, "ElementType = %s\n", mhdDataPixelType.c_str() );  
                   fprintf(fp, "ElementDataFile = ..%c2dseq_Slice_%d\n", GDCM_NAME_SPACE::GDCM_FILESEPARATOR, sliceNb ); 
                   fclose(fp);
               } // end write MHD

               sprintf(output2dseqSliceFileName, "%s%c2dseq_Slice_%d", 
                                                 currentOutputDirName.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR,sliceNb);
               fp=fopen(output2dseqSliceFileName, "wb");
               if (!fp)
               {     
                   std::cout << "Cannot open [" << output2dseqSliceFileName << "] for writting" << std::endl;
		   throw ( BrukerHopelessException ("Hopeless! Cannot open 2dseqSliceFile file for writting"));		   
                   //exit (0);
               }
               int frameSize = NX*NY*pixelSize;
               for (instantNb=0; instantNb<nbInstants; instantNb++)
               {
// std::cout << "------------SN " << sliceNb << " IN " << instantNb <<  " T " << nbSlices*instantNb + sliceNb << std::endl;
                    fwrite( buffer_2dseq +(nbSlices*instantNb + sliceNb)*frameSize,
                            frameSize,
                            1, fp);
               }
               fclose(fp);
// std::cout << "end writting[" << output2dseqSliceFileName << "]" << std::endl;
            }  // end if mhd
   
            if (dicom)
            {
               // desperate try !
             /* 
               sprintf(output2dseqSliceFileName, "%sdummy_buffer", 
                                                 currentOutputDirName.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR);
               fp=fopen(output2dseqSliceFileName, "wb");
               if (!fp)
               {     
                   std::cout << "Cannot open [" << output2dseqSliceFileName << "] for writting" << std::endl;
                   exit (0);
               }
               int frameSize = NX*NY*pixelSize;
               for (instantNb=0; instantNb<nbInstants; instantNb++)
               {
// std::cout << "------------SN " << sliceNb << " IN " << instantNb <<  " T " << nbSlices*instantNb + sliceNb << std::endl;
                    fwrite( buffer_2dseq +(nbSlices*instantNb + sliceNb)*frameSize,
                            frameSize,
                            1, fp);
               }
               fclose(fp);
       
               fp=fopen(output2dseqSliceFileName, "rb");
               if (!fp)
               {     
                   std::cout << "Cannot open [" << output2dseqSliceFileName << "] for reading" << std::endl;
                   exit (0);
               }       
               fread( pixelsForCurrentSlice,
                            frameSize*nbInstants,
                            1, fp);
               fclose(fp);
              // end of desperate try !
              */

               /* ----------- Write Dicom Image  ---------------*/
       
               int frameSize = NX*NY*pixelSize;
               for (instantNb=0; instantNb<nbInstants; instantNb++)
               {
                  memcpy(pixelsForCurrentSlice + frameSize*instantNb, buffer_2dseq +(nbSlices*instantNb + sliceNb)*frameSize, frameSize);
               }

               int indOfFirsImageWithinImageSet =  nbSlices*instantNb;
               sprintf(output2dseqSliceFileName, "%s%c2dseq_Slice_%d.dcm", 
                                                 currentOutputDirName.c_str(), GDCM_NAME_SPACE::GDCM_FILESEPARATOR, sliceNb);

               MakeDicomImage(
                  pixelsForCurrentSlice,
                  NX,
                  NY,
                  nbInstants,
                  pixelSize,
		  spatResolX, spatResolY, sliceDistance,
                  //fovX/NY, fovY/NY, sliceDistance,
                  output2dseqSliceFileName,
                  subject_name,
                  day,
                  strStudyUID,
                  strSerieUID,
                  strStudyDescr,
                  strSerieDescr,
                  strStudyTimeDate,
                  sliceNb*nbInstants,
                  GDCM_NAME_SPACE::UNMODIFIED_PIXELS_IMAGE
               );
               if (verbose)
                  std::cout << "--- Output DCM file [" << output2dseqSliceFileName << "]" << std::endl;      

           } // en if dicom

        k++;
        }
        delete [] pixelsForCurrentSlice;  
     }  // end nbInstants == 1
   delete [] buffer_2dseq;
/**/


   // -----------------------------------------------------
   //  deal with MatLab-generated Carto file.
   // -----------------------------------------------------

   dealWithCarto(fileNames,  NX,  NY,  nbSlices, /*fovX, fovY,*/ spatResolX, spatResolY, sliceDistance,
                   copyFile, currentOutputDirName, outputMhdFileName, output2dseqCartoName);
}


// ===========================================================================================

void Bruker2Dicom::dealWithCarto(GDCM_NAME_SPACE::DirListType &fileNames, int NX, int NY, int nbSlices, 
                                 /*double fovX, double fovY, */
				 double spatResolX, double spatResolY, double sliceDistance,
                                 char *copyFile, std::string &currentOutputDirName, 
                                 char *outputMhdFileName, char *output2dseqCartoName)
{
   // -----------------------------------------------------
   //  deal with MatLab-generated Carto file.
   // -----------------------------------------------------
   
   const char *code[] = { "ADC", "adc", "TTP", "ttp", "PEAK", "peak", "" };  // add more carto file name identifiers if necessary; end with ""
   const char *separator[] =  { "_", ".", "-", "" }; //  add more, if necessary, to ckeck for 2dseq.ADC, 2dseq_ADC, 2dseq-ADC, etc; end with ""
   int icode;
   int iseparator; 
   GDCM_NAME_SPACE::DirListType::iterator it;
   char file_name_ident[500];
   FILE *fp;

   // Iterate to ALL the objets(files/directories) found in the input directory    
   for (it = fileNames.begin();
        it != fileNames.end();
      ++it)
   {
      if ( boost::filesystem::is_regular(*it) )
      //if ( ! boost::filesystem::is_directory(*it) )
      {         
         if (verbose)
            std::cout << "--- [" << *it << "] is a file..." << std::endl;

         icode      = 0;
         while (code[icode][0] != 0)
         { 
	 iseparator = 0;       
	 while (separator[iseparator][0] != 0)
         {
            sprintf(file_name_ident, "2dseq%s%s",separator[iseparator],code[icode]); // e.g  "2dseq_ADC"
	    //if (verbose)
	    //   std::cout << "check name ["<<(*it) << "] for string [" << file_name_ident << "]" << std::endl;
            std::string::size_type loc = (*it).rfind(file_name_ident); 

            if ( loc != std::string::npos )
            {

       ///\ TODO : find a safer way to be sure to read everything!
              unsigned char *buffer_carto = new unsigned char[NX*NY*sizeof(double)*nbSlices];
              fp = fopen ( (*it).c_str(), "rb");
              if (!fp){
                 std::cout << "Cannot open [" << *it << "] for reading" << std::endl;
                 throw ( BrukerHopelessException ("Level 1 Unable to open 'carto' file "));
               }
               fread(buffer_carto, NX*NY*sizeof(double), nbSlices, fp);

                    // ?!?  sprintf(copyFile, "cp %s %s%c%s", (*it).c_str() ,
               std::cout << "Deal with Carto file :[" <<*it << "], computed length : "
                         << NX*NY*sizeof(double)*nbSlices << std::endl;
               std::string lastFileName = GDCM_NAME_SPACE::Util::GetName((*it).c_str());
               if (mhd)
               {
                  // Copy the data file in the new directory
                  sprintf(copyFile, "cp %s %s%c%s", (*it).c_str() ,
                            currentOutputDirName.c_str(),GDCM_NAME_SPACE::GDCM_FILESEPARATOR, lastFileName.c_str()); 
                  system(copyFile);
                  sprintf(outputMhdFileName, "%s%c%s%s",
                                         currentOutputDirName.c_str(),GDCM_NAME_SPACE::GDCM_FILESEPARATOR, lastFileName.c_str(), ".mhd" );
                  if (verbose)
                    std::cout << "--- Output Carto MHD file [" << outputMhdFileName << "]" << std::endl;

                  FILE *fp;
                  fp=fopen(outputMhdFileName, "w");
                  if (!fp)
                  {
                     std::cout << "Cannot open [" << outputMhdFileName << "] for writting" << std::endl;
                  }
                  else
                  {
                     fprintf(fp, "ObjectType = Image\n");
                     fprintf(fp, "NDims = 3\n" );
                     fprintf(fp, "BinaryData = True \n" );
                     fprintf(fp, "BinaryDataByteOrderMSB = False\n" );
                     fprintf(fp, "DimSize = %d %d %d\n", NX, NY, nbSlices);
                     fprintf(fp, "HeaderSize = %d\n", 0 );
                     fprintf(fp, "ElementSpacing = %lf %lf %lf\n",spatResolX, spatResolY, sliceDistance );
                     fprintf(fp, "Position = 0 0 0\n" );
                     fprintf(fp, "Offset = 0 0 0\n" );
                     fprintf(fp, "CenterOfRotation = 0 0 0\n" );
                     fprintf(fp, "ElementNumberOfChannels = 1\n" );
                     fprintf(fp, "ElementType = %s\n", "MET_DOUBLE" );
                     fprintf(fp, "ElementDataFile = %s\n", lastFileName.c_str() );

                     fclose(fp);
                  }
                  if (verbose)
                     std::cout << "--- end write Carto MHD file [" << outputMhdFileName << "]" << std::endl;
               }  // end if mhd

            // ----------- Write Dicom Image  ---------------

               if (dicom)
               {
                  sprintf(output2dseqCartoName, "%s%c%s%s",
                                       currentOutputDirName.c_str(),GDCM_NAME_SPACE::GDCM_FILESEPARATOR, lastFileName.c_str(), ".dcm" );
                  if (verbose)
                     std::cout << "--- end create name output2dseqCartoName file [" << output2dseqCartoName << "]" << std::endl;

                  strSerieUID =  GDCM_NAME_SPACE::Util::CreateUniqueUID(); //New SerieUID for each carto.
                  std::string strNewSerieDescr(strSerieDescr+ "_" +GDCM_NAME_SPACE::Util::GetName((*it).c_str()));
                  MakeDicomImage(buffer_carto,
                     NX,
                     NY,
                     nbSlices,
                     8, // pixelSize
                     //fovX/NY, fovY/NY, sliceDistance,
                     spatResolX, spatResolY, sliceDistance,
                     output2dseqCartoName,
                     subject_name,
                     day,
                     strStudyUID,
                     strSerieUID,
                     strStudyDescr,
                     strNewSerieDescr,
                     strStudyTimeDate,
                     0,
                     GDCM_NAME_SPACE::CREATED_IMAGE
                  );
               }  // end if dicom

               delete [] buffer_carto;
               if (verbose) 
                  std::cout << "--- End writing Carto DICOM file [" << output2dseqCartoName << "]" << std::endl;
               break; // don't check for more ident on same file name!
	    
            }  // end deal with _ADC, -adc, etc
          iseparator ++;
          }  // end iterate speparators
          icode++;
          } // end iterate code
      } // end boost::filesystem::is_regular(*it)
   } // end iterate on all objects (files, dir, etc)
} // end method


// ==========================================================================================================
  
bool Bruker2Dicom::CreateDirectory(std::string OutputDirName)
{
   std::string systemCommand;
   
   if (verbose)
      std::cout << "Check for output directory :[" << OutputDirName << "]."
                <<std::endl;
   if ( ! boost::filesystem::is_directory(OutputDirName) )    // dirout not found
   {
      std::string strDirNameout(OutputDirName);        // to please gcc 4
      systemCommand = "mkdir " + strDirNameout;        // create it!
      if (verbose)
         std::cout << systemCommand << std::endl;
      system (systemCommand.c_str());
      if ( ! boost::filesystem::is_directory(OutputDirName) ) // be sure it worked
      {
         if (verbose) 
            std::cout << "KO : not a dir : [" << OutputDirName << "] (creation failure ?)" << std::endl;
         //return 0;
	 throw ( BrukerHopelessException ("Level 1 output directory creation failure "));
      }
      else
      {
         if (verbose) 
           std::cout << "Directory [" << OutputDirName << "] created." << std::endl;
      }
   }
   else
   {
       if (verbose)
            std::cout << "Output Directory [" << OutputDirName << "] already exists; Used as is." << std::endl;
   }
   
   return 1;

}


// ===========================================================================================

/// \TODO move cleanString to 'crea' ?

void Bruker2Dicom::cleanString(std::string &s)
{
   int l = s.size();
   if (s[l-1] == 0x0A || s[l-1] == 0x0D ) // CR or NL
   {
      l--;
      s = s.substr(0, l);
   }
   if (s[l-1] == ' ' ) // blank space
   {
      l--;
      s = s.substr(0, l);
   }   
   
   if (s[0] == '<')      
      s= s.substr(1,l-2);
   std::string repChar("_");   
   GDCM_NAME_SPACE::Util::ReplaceSpecChar(s, repChar);
}



// ===========================================================================================


void Bruker2Dicom::getImhDataType(BrukerFieldData &bDPT, std::string &mhdDataPixelType, int &pixelSize)
{ 
   if(bDPT.GetDataType() == "string")
   {         
         std::string brukerDataPixelType = bDPT.GetStringValue()[0];
	 if (verbose)
            std::cout << "DATTYPE " << brukerDataPixelType << std::endl;          
         //std::string brukerDataPixelType = br_d3proc.GetFieldData("DATTYPE").GetStringValue()[0];
         
         if (brukerDataPixelType ==  "ip_short") {
            mhdDataPixelType = "MET_USHORT";
            pixelSize = 2;
         }
         if (brukerDataPixelType ==  "ip_int") {
            mhdDataPixelType = "MET_UINT";
            pixelSize = 4;
         }
         if (brukerDataPixelType ==  "ip_char") {
             mhdDataPixelType = "MET_UCHAR";
             pixelSize = 1;
         }
                  /// \TODO : finish the list
    /*
    case 0 : fp << "ElementType = MET_CHAR" << std::endl;
      break;
    case 1 : fp << "ElementType = MET_UCHAR" << std::endl;
      break;
    case 2 : fp << "ElementType = MET_SHORT" << std::endl;
      break;
    case 3 : fp << "ElementType = MET_USHORT" << std::endl;
      break;
    case 4 : fp << "ElementType = MET_INT" << std::endl;
      break;
    case 5 : fp << "ElementType = MET_UINT" << std::endl;
      break;
    case 6 : fp << "ElementType = MET_FLOAT" << std::endl;
      break;
    case 7 : fp << "ElementType = MET_DOUBLE" << std::endl;  
    */
    }
    else
    {
         int brukerDataPixelType = bDPT.GetIntValue()[0];
         if (verbose)
	    std::cout << "DATTYPE " << brukerDataPixelType << std::endl;          
         //std::string brukerDataPixelType = br_d3proc.GetFieldData("DATTYPE").GetStringValue()[0];
 
// Cross your fingers !!!

// pb : found values : 2, 3, 5
         
         if (brukerDataPixelType ==  2) {
            mhdDataPixelType = "MET_USHORT";
            pixelSize = 2;
         }
         if (brukerDataPixelType ==  3) {
            mhdDataPixelType = "MET_USHORT";
            pixelSize = 2;
         }    
         if (brukerDataPixelType ==  1) {
            mhdDataPixelType = "MET_UCHAR";
            pixelSize = 1;
         }     
    }
}

// ===========================================================================================

std::vector<BrukerImage> Bruker2Dicom::CreateImageSet ( )
{
         std::vector<BrukerImage> imageSet;      
         br_acqp.SetLoopStructure();
         std::vector<int> tempVect                      = br_acqp.GetLoopStructure() ;
         std::map<std::string, BrukerFieldData> map     = br_acqp.GetBrukerHeaderMap();
	 
         bool result                                    = br_acqp.ObjectVaryingProperties.init(map,tempVect);
 
         if (result == false)
	 {
	    throw ( BrukerInitException  ("ObjectVaryingProperties.init() failure in Bruker2Dicom::CreateImageSet()") );
	 }

         br_acqp.SetImageLoopStructure();
         br_acqp.SetBrukerImageList();
         std::vector<std::vector<int> > brukerImageList = br_acqp.GetBrukerImageList();

         BrukerImage image(br_acqp,br_reco);
         image.Init(br_acqp,br_reco,1); 
 
         for(int i=0;i<brukerImageList.size();i++)
         {
            image.Init(br_acqp,br_reco,i);    
            imageSet.push_back(image);
         }
 
 // Just for checking
 /*
 
         std::vector<std::vector <double> > imageOrientation;
         std::vector <double> imagePosition; 
         for(int i=0;i<brukerImageList.size();i++)
         {
           // fread(buffer_2dseq, NX*NY*pixelSize*nbSlices*nbInstants, 1, fp);   
   
           imagePosition = imageSet[i].getTranslationVectorRPS2XYZ();
           std::cout << "Position " << imagePosition[0] << " " 
                     << imagePosition[1] << " "  << imagePosition[2] ;
           imageOrientation =  imageSet[i].getRotationMatrixRPS2XYZ();
           std::cout << "\t  Orientation " ;
           for(int i1=0; i1<3;i1++)for(int i2=0; i2<3;i2++)
              std::cout << imageOrientation[i1][i2] << " ";CreateImageSet
       
           //std::cout << "\t  Abs Time " << imageSet[i].getAbsoluteTimePosition();
           std::cout << "\t  Relat Time " << imageSet[i].getRelativeTimePosition();

           std::cout << "\t [";
           for (int i3=0; i3<imageSet[i].getLoopStamp().size();i3++)
              std::cout << " " << imageSet[i].getLoopStamp()[i3];
           std::cout << "]" << std::endl;       
         } 
*/
   return imageSet;
}

// ===========================================================================================

void Bruker2Dicom::MakeDicomImage(unsigned char *tabPixels, 
              int X, 
              int Y,
              int nbFrames,
              int pixelSize,
              double spacingX, double spacingY, double sliceDistance, 
              std::string dcmImageName,
              const std::string &patientName,
              const char *day,
              std::string &studyUID,
              std::string &serieUID,
              std::string &studyDescr,
              std::string &serieDescr,
              std::string &strStudyTimeDate,
              int imgNum,
              GDCM_NAME_SPACE::ImageContentType contentType 
      )
{  
   std::ostringstream str;

   GDCM_NAME_SPACE::File *file;
   file = GDCM_NAME_SPACE::File::New();       
      
  // Set the image size
   str.str(""); 
   str << X;
   file->InsertEntryString(str.str(),0x0028,0x0011,"US"); // Columns
   str.str("");
   str << Y;
   file->InsertEntryString(str.str(),0x0028,0x0010,"US"); // Rows

   if (nbFrames != 1)
   {
      str.str("");
      str << nbFrames;
      file->InsertEntryString(str.str(),0x0028,0x0008,"IS"); // Number of Frames  
   }

  // Set the pixel type
  //      //8, 16, 32, 64 (for double ?)
   str.str("");
   str << pixelSize*8;     
   file->InsertEntryString(str.str(),0x0028,0x0100,"US"); // Bits Allocated

   file->InsertEntryString(str.str(),0x0028,0x0101,"US"); // Bits Stored

   str.str("");
   str << pixelSize*8-1;     
   file->InsertEntryString(str.str(),0x0028,0x0102,"US"); // High Bit

  // Set the pixel representation // 0/1 , 0=unsigned
   file->InsertEntryString("1",0x0028,0x0103, "US"); // Pixel Representation
   
  // Set the samples per pixel // 1:Grey level, 3:RGB
   file->InsertEntryString("1",0x0028,0x0002, "US"); // Samples per Pixel

//  0028 0030 DS 2 Pixel Spacing
   str.str("");
   str << spacingX << "\\" << spacingY;
   file->InsertEntryString(str.str(),0x0028,0x0030, "DS"); // Pixel Spacing     
   
 //   0018 0050 DS 1 Slice Thickness 
   str.str("");    
   str << sliceDistance;
   file->InsertEntryString(str.str(),0x0018,0x0050, "DS"); 
   
//    0020 0011 IS 1 Series Number
   str.str("");    
   str << serieNumber;
   file->InsertEntryString(str.str(),0x0020,0x0011, "IS");
      
//    0020|0013 [IS]  [Instance Number] 
   instanceNumber++;
   str.str("");    
   str << instanceNumber;
   file->InsertEntryString(str.str(),0x0020,0x0013, "IS");
   
       
  // 1.2.840.10008.5.1.4.1.1.4.1 : Enhanced MR Image Storage
 //  file->InsertEntryString("1.2.840.10008.5.1.4.1.1.4.1" , 0x0002, 0x0002, "UI");  // [Media Storage SOP Class UID]
  // file->InsertEntryString("1.2.840.10008.5.1.4.1.1.4.1" , 0x0008, 0x0016, "UI");  // [SOP Class UID]


// OK : MR is NOT multiframe, but I want just a quick an dirty solution

// 1.2.840.10008.5.1.4.1.1.4         MR Image Storage
   file->InsertEntryString("1.2.840.10008.5.1.4.1.1.4" , 0x0002, 0x0002, "UI");  // [Media Storage SOP Class UID]
   file->InsertEntryString("1.2.840.10008.5.1.4.1.1.4" , 0x0008, 0x0016, "UI");  // [SOP Class UID]     

  // if (strlen(patientName) != 0)
   file->InsertEntryString(patientName.c_str(),0x0010,0x0010, "PN"); // Patient's Name

   file->InsertEntryString(studyUID, 0x0020, 0x000d, "UI");
   file->InsertEntryString(serieUID, 0x0020, 0x000e, "UI");
   
//  0008 0020 DA 1 Study Date
//  0008 0030 TM 1 Study Time

/// \TODO split into 2 strings!
   file->InsertEntryString(strStudyTimeDate.substr(10,11).c_str(),0x0008,0x0020, "DA");
   file->InsertEntryString(strStudyTimeDate.substr(1,8).c_str(),  0x0008,0x0030, "TM");

   file->InsertEntryString(studyDescr, 0x0008,0x1030, "LO");  // Study Description  
   file->InsertEntryString(serieDescr, 0x0008,0x103e, "LO");  // Series Description 

//0008|0060 [CS] [Modality] 
   file->InsertEntryString("MR",0x0008,0x0060, "CS");

// 0020 0037 DS 6 Image Orientation (Patient)
   char charImageOrientation[256];

/*
std::cout << "charImageOrientation  " << 
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[0][0] << " " <<
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[0][1] << " " <<
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[0][2] << " " <<
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[1][0] << " " <<
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[1][1] << " " <<
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[1][2] << std::endl ;
*/      
   sprintf(charImageOrientation,"%f\\%f\\%f \\ %f\\%f\\%f",
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[0][0],
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[0][1],
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[0][2],
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[1][0],
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[1][1],
                              imageSet[imgNum].getRotationMatrixRPS2XYZ()[1][2] ) ;
    
   file->InsertEntryString(charImageOrientation,0x0020,0x0037, "DS");


// 0020 0032 DS 3 Image Position (Patient) 

   char charImagePosition[256];   
   sprintf(charImagePosition,"%f\\%f\\%f", 
                             imageSet[imgNum].getTranslationVectorRPS2XYZ()[0], 
                             imageSet[imgNum].getTranslationVectorRPS2XYZ()[1],
                             imageSet[imgNum].getTranslationVectorRPS2XYZ()[2]);
  
   file->InsertEntryString(charImagePosition,0x0020,0x0032, "DS");  //0020 0032 DS 3 Image Position (Patient) 
         


// 0020 0x1041 DS 1 Slice Location 
//        sprintf(charImagePosition,"%f",float(imgNum));
//        file->InsertEntryString(charImagePosition,0x0020,0x1041, "DS");   
/*
  // Set Rescale Intercept
        str.str("");
        str << div;  
        file->InsertEntryString(str.str(),0x0028,0x1052,"DS");

  // Set Rescale Slope
        str.str("");
        str << mini;  
        file->InsertEntryString(str.str(),0x0028,0x1053,"DS");
*/

   GDCM_NAME_SPACE::FileHelper *fileH;
   fileH = GDCM_NAME_SPACE::FileHelper::New(file);
   fileH->SetContentType(contentType);   
    
   // cast is just to avoid warnings (*no* conversion is performed)
   //fileH->SetImageData((uint8_t *)img,int(maxX*maxY)*sizeof(uint16_t)); // troubles when maxX, mayY are *actually* float!

//std::cout << "--------------------------------  X*Y*nbFrames*pixelSize " << X << " " << Y << " " << nbFrames << " " << pixelSize << std::endl; 

   fileH->SetImageData((uint8_t *)tabPixels, X*Y*nbFrames*pixelSize);
   fileH->SetWriteModeToRaw(); 
   fileH->SetWriteTypeToDcmExplVR();
   if( !fileH->Write(dcmImageName)) {
      std::cout << "Failed for [" << dcmImageName << "]\n"
                << "           File is unwrittable" << std::endl;		
      file->Delete();
      fileH->Delete(); 		
      throw ( BrukerHopelessException ("Level 1 Unable to write Dicom file "));
   }
   //if (verbose)
   //   file->Print();

   file->Delete();
   fileH->Delete();  
}


