#ifndef BRUKER2DICOM_H
#define BRUKER2DICOM_H


#include "gdcmFile.h"
#include "gdcmFileHelper.h"
#include "gdcmCommon.h"
#include "gdcmDebug.h"
#include "gdcmUtil.h"
#include "gdcmDirList.h"

#include "gdcmArgMgr.h"
#include "brukerSystem.h"
#include "brukerdataset.h"
#include "brukerkspaceobject.h"
#include "brukerimage.h"

#include <iostream>
#include <sstream>



class creaBruker_EXPORT Bruker2Dicom {

public:
 /*! \brief Constructor
*/
  Bruker2Dicom () /* : verbose(0), mhd(0), dicom(0), day(O)*/ {};
/*! \brief Destructor
*/
  ~Bruker2Dicom (){};

  void SetInputDirectory (const std::string &i) { InputDirName   = i;}
  void SetOutputDirectory(const std::string &o) { OutputDirName  = o;}
  void SetConvertModeToDicom()                  { dicom = 1; mhd = 0;}
  void SetConvertModeToMhd()                    { dicom = 0; mhd = 1;}  
  bool Execute();
  
  /* 
  // For debugging pupose only.
  //Don't need accessors : Attributes are 'public' 
  
  void SetVerbose(int v) { verbose = v;}
  void SetMhd(int m)     { mhd = m;    }
  void SetDicom(int d)   { dicom = d;  }
  */     

private :

void MakeDicomImage(unsigned char *tabPixels, 
              int X, 
              int Y,
              int nbFrames,
              int pixelSize,
              double spacingX, double spacingY, double sliceDistance, 
              std::string dcmImageName,
              const std::string &patientName,
              const char *day,
              std::string &studyUID,
              std::string &serieUID,
              std::string &studyDescr,
              std::string &serieDescr,
	      std::string &strStudyTimeDate,
              int imgNum,
              GDCM_NAME_SPACE::ImageContentType contentType 
      );
      
std::vector<BrukerImage> CreateImageSet ( );

void getImhDataType(BrukerFieldData &bDPT, 
                    std::string &mhdDataPixelType, 
		    int &pixelSize);
		    
void cleanString(std::string &s);

bool CreateDirectory(std::string dirNameout);

void DealWithNiveau1(std::string level1Directory, std::string currentOutputDirName);
void DealWithNiveau2(std::string level2Directory, std::string currentOutputDirName);
void DealWithNiveau3(std::string level3Directory, std::string currentOutputDirName);
		    
void dealWithCarto(GDCM_NAME_SPACE::DirListType &fileNames, int NX, int NY, int nbSlices, 
                   double fovX, double fovY, double sliceDistance,
                   char *copyFile, std::string &currentOutputDirName, 
		   char *outputMhdFileName, char *output2dseqCartoName);

public:

// these ones are for debugging only
// don't bbfy the accessors.

   int verbose;
   const char *day;
       
private :
   std::string InputDirName;
   std::string OutputDirName;
 
   int mhd;
   int dicom;
     
   int nbSlices;
   BrukerDataSet br_subject;
   BrukerDataSet br_acqp;
   BrukerDataSet br_method;
   BrukerDataSet br_d3proc;
   BrukerDataSet br_isa;
   BrukerDataSet br_reco;

   std::vector<BrukerImage> imageSet;

// For DICOM images.

   std::string strStudyUID; 
   std::string strSerieUID; 
   std::string strStudyDescr; 
   std::string strSerieDescr;
   std::string strStudyTimeDate;
   std::string strPatientName;
   std::string subject_name; // cleaned strPatientName
   
   
   int serieNumber;
   int instanceNumber;      
};


#endif
