#ifndef BRUKERFIELDDATA_H
#define BRUKERFIELDDATA_H
/*! \file brukerFieldData.h
*/
#include <string>
#include <vector>
#include "brukerSystem.h"

 /**
\class  BrukerFieldData
    \brief This class is an atom to generate a BrukerDataSet
   */
class creaBruker_EXPORT BrukerFieldData {
friend class BrukerDataSet;
public:
 /*! \brief Constructor
*/
  BrukerFieldData () {};
/*! \brief Destructor
*/
  ~BrukerFieldData (){};
/*! \brief Returns the keyword type: int, float, string as a string
*/
  const std::string &GetDataType()                   { return DataType;}
/*! \fn int GetDimensionNumber()
	\brief Returns the dimension of the keyword:
	0-> scalar
	1-> 1D vector
	 2-> 2D vector
	...
*/
  int GetDimensionNumber()                           { return DimensionNumber;}
/*! \fn const std::vector<int> &GetDimensionNumberValue( )
\brief Returns a vector of size DimensionNumber giving the size of each dimension of the keyword
*/
  const std::vector<int> &GetDimensionNumberValue( ) { return DimensionNumberValue;}
/*! \fn int GetNumberOfElements()     
\brief Returns the total number of elements for keyword
*/
  int GetNumberOfElements()                          { return NumberOfElements;}
/*! 
\fn const std::vector<std::string> &GetStringValue() 
\brief Return a string vector of all the element of keyword
*/
  const std::vector<std::string> &GetStringValue()   { return StringValue;}
/*! 
\fn const std::vector<int> &GetIntValue () 
\brief Return an int vector of all the element of keyword
*/
  const std::vector<int> &GetIntValue ()             { return IntValue;}
/*! 
\fn const std::vector<double> &GetDoubleValue()
\brief Return a double vector of all the element of keyword
*/
  const std::vector<double> &GetDoubleValue()        { return DoubleValue;}


 void PrintSelf();

private :
/*! \var  DataType
\brief Datatype of the keyword content
*/
  std::string DataType;
/*! \var DimensionNumber
\brief Dimmensionnality of the keyword
*/
  int DimensionNumber;
/*! \var DimensionNumberValue
\brief Vector of int giving the dimension of each dimension of the keyword content 
*/
  std::vector<int> DimensionNumberValue;
/*! \var NumberOfElements
\brief Total number of elements contained in keyword
*/
  int NumberOfElements;
/*! \var StringValue
\brief Vector of string containing the elements of keyword if they are string
*/
  std::vector<std::string> StringValue;
/*! \var IntValue
\brief Vector of string containing the elements of keyword if they are string
*/
  std::vector<int> IntValue;
/*! \var DoubleValue
\brief Vector of string containing the elements of keyword if they are string
*/
  std::vector<double> DoubleValue;
};
#endif
