//
#ifndef BRUKEREXCEPTION_H
#define BRUKEREXCEPTION_H

#include "brukerSystem.h"
#include <exception>
#include <string>


class creaBruker_EXPORT BrukerSizeException: public std::exception
{
public:
    BrukerSizeException( const std::string& message,
		      int lgt,
		      int expected_lgt
		      )
      : m_message(message), m_lgt(lgt), m_expected_lgt(expected_lgt)
    {}

    ~BrukerSizeException() throw() {}
    
    virtual const char* what() const throw() {
        return m_message.c_str();
    }
    
   int getFoundLgt() const throw() {
        return m_lgt;
   }
   
   int getExpectedLgt() const throw() {
        return m_expected_lgt;
   }
     
private:
   std::string m_message;
   int m_lgt;
   int m_expected_lgt;

};


class creaBruker_EXPORT BrukerInitException: public std::exception
{
public:
    BrukerInitException( const std::string& message
		      )
      : m_message(message)
    {}

    ~BrukerInitException() throw() {}
    
    virtual const char* what() const throw() {
        return m_message.c_str();
    }
    
     
private:
   std::string m_message;

};

class creaBruker_EXPORT BrukerHopelessException: public std::exception
{
public:
    BrukerHopelessException( const std::string& message
		      )
      : m_message(message)
    {}

    ~BrukerHopelessException() throw() {}
    
    virtual const char* what() const throw() {
        return m_message.c_str();
    }
    
     
private:
   std::string m_message;

};

#endif
