//
// C++ Interface: brukerimage
//
// Description: 
//
//
// Author: Denis Grenier, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BRUKERIMAGE_H
#define BRUKERIMAGE_H

#include "brukerdataset.h"
#include "brukerSystem.h"
/**
This class centralizes the informations "needed" to exploit a bruker image file 2dseq

	@author Denis Grenier
	@file brukerimage.h
*/
class creaBruker_EXPORT BrukerImage{
public:
   BrukerImage(BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco);
   ~BrukerImage();

   bool Init(BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	
   int                  getAbsoluteTimePosition()   const;
   double               getRelativeTimePosition()   const;
   const std::vector <int>    &getFOVpixels()       const;
   const std::vector <double> &getFOVcm()           const;
   double               getSliceThickness()         const;
   double               getTE()                     const;
   double               getTR()                     const;
   double               getTI()                     const;
   double               getFlipAngle()              const;
   int                  getNA()                     const;
   int                  getNR()                     const;
   int                  getDS()                     const;
   int                  getNAE()                    const;
   int                  getACQ_phase_factor()       const;
   std::string          getWordType()               const;
   std::string          getImageType()              const;
   const std::string   &getDataEndianness()         const;
   size_t               getImageByteSize()          const;
   size_t               getBeginingOfImageInBytes() const;
   
   const std::vector <int>    &getLoopStamp() const;

   const std::vector<std::vector <double> >  &getRotationMatrixRPS2XYZ()    const;
   const std::vector <double>                &getTranslationVectorRPS2XYZ() const;
	
	
protected:

private:

// on devrait plutot les nommer 'computeXXX' (setXXX est d'habitude reserve aux accesseurs 'publics')

	bool setAbsoluteTimePosition    (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setRelativeTimePosition    (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setFOVpixels               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setFOVcm                   (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setSliceThickness          (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTE                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTR                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTI                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setFlipAngle               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setLoopStamp               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setNA                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setNR                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setNAE                     (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setDS                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setACQ_phase_factor        (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setRotationMatrixRPS2XYZ   (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTranslationVectorRPS2XYZ(BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setWordType                (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setImageType               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setDataEndianness          (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setImageByteSize           (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setBeginingOfImageInBytes  (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);

        std::vector<int>    FOVpixels;
        std::vector<double> FOVcm;
        std::vector<int>    LoopStamp;
        double SliceThickness;
        double TE;
        double TR;
        double TI;
        double FlipAngle;
        double RelativeTimePosition;
        int NA;
        int NR;
        int NAE;
        int DS;
        int ACQ_phase_factor;
        std::vector<std::vector<double> >  RotationMatrixRPS2XYZ;
        std::vector<double>                TranslationVectorRPS2XYZ;
        int  AbsoluteTimePosition;
        std::string WordType;
        std::string ImageType;
        std::string DataEndianness;
        size_t ImageByteSize;
        size_t BeginingOfImageInBytes;

};

#endif
