//
// C++ Implementation: brukerobject
//
// Description: 
//
//
// Author:  <Denis Grenier>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "brukerkspaceobject.h"



bool BrukerKspaceObject::FillWithObject(BrukerDataSet DataSet, int ObjectNumber)
{

  std::string TempString;
  std::vector< int > TempVectInt;
  std::vector<double> TempVectDouble;

  TempString="ACQ_abs_time";
  if (DataSet.CheckExistKeyword(TempString)) {
    setAbsoluteTimePosition ( DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]  );
  }
  else return false;

  TempString="ACQ_phase_factor";
  if (DataSet.CheckExistKeyword(TempString)) {
    setACQ_phase_factor(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="ACQ_dim";
  if (DataSet.CheckExistKeyword(TempString)) {
    setDimension(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="ACQ_size";
  if (DataSet.CheckExistKeyword(TempString)){
    for (int i=0;i<getDimension();i++) 
      TempVectInt.push_back(DataSet.BrukerHeaderMap[TempString].GetIntValue()[i]);
    setDimensionSizes(TempVectInt);
    TempVectInt.clear();
  }
  else return false;

  TempString="ACQ_flip_angle";
  if (DataSet.CheckExistKeyword(TempString)){ 
    setFlipAngle(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="ACQ_fov";
  if (DataSet.CheckExistKeyword(TempString)) {
    if ( 1!=DataSet.BrukerHeaderMap[TempString].GetDimensionNumber()) 
      return false;
    for (int i=0;i<DataSet.BrukerHeaderMap[TempString].GetNumberOfElements();i++){ 
      TempVectDouble.push_back(DataSet.BrukerHeaderMap[TempString].GetDoubleValue()[i]);
    }
    setFOV(TempVectDouble);
    TempVectDouble.clear();
  }
  else return false;

  TempString="NA";
  if (DataSet.CheckExistKeyword(TempString)){ 
  setNA(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="NR";
  if (DataSet.CheckExistKeyword(TempString)){ 
  setNA(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="NSLICES";
  if (DataSet.CheckExistKeyword(TempString)){ 
  setNA(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="NI";
  if (DataSet.CheckExistKeyword(TempString)){ 
    setNI(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="NAE";
  if (DataSet.CheckExistKeyword(TempString)){ 
    setNAE(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;

  TempString="DS";
  if (DataSet.CheckExistKeyword(TempString)){ 
    setDS(DataSet.BrukerHeaderMap[TempString].GetIntValue()[0]);
  }
  else return false;


  TempString="ACQ_ns_list";
  if (DataSet.CheckExistKeyword(TempString)) {
  for (int i=0;i<DataSet.BrukerHeaderMap[TempString].GetNumberOfElements();i++){ 
    TempVectInt.push_back(DataSet.BrukerHeaderMap[TempString].GetIntValue()[i]);
  }
  setACQ_ns_list(TempVectInt);
  TempVectInt.clear();
  }
  else return false;

  TempString="ACQ_obj_order";
  if (DataSet.CheckExistKeyword(TempString)) {
  for (int i=0;i<DataSet.BrukerHeaderMap[TempString].GetNumberOfElements();i++){ 
    TempVectInt.push_back(DataSet.BrukerHeaderMap[TempString].GetIntValue()[i]);
  }
  setACQ_obj_order(TempVectInt);
  TempVectInt.clear();
  }
  else return false;

  TempString="ACQ_echo_time";
  if (DataSet.CheckExistKeyword(TempString)) {
  for (int i=0;i<DataSet.BrukerHeaderMap[TempString].GetNumberOfElements();i++){ 
    TempVectInt.push_back(DataSet.BrukerHeaderMap[TempString].GetIntValue()[i]);
  }
  setACQ_echo_time(TempVectInt);
  TempVectInt.clear();
  }
  else return false;

  return true;
}

