//
// C++ Interface: brukerobject
//
// Description: 
//
//
// Author:  <Denis Grenier>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BRUKERKSPACEOBJECT_H
#define BRUKERKSPACEOBJECT_H

#include <vector>
#include "brukerSystem.h"
#include "brukerdataset.h"


class creaBruker_EXPORT BrukerKspaceObject{
public:
   BrukerKspaceObject(BrukerDataSet DataSet);
   ~BrukerKspaceObject();



   void setAbsoluteTimePosition ( long theValue )
   {
      AbsoluteTimePosition = theValue;
   }
	


   long  getAbsoluteTimePosition() const
   {
      return AbsoluteTimePosition;
   }

   void setACQ_phase_factor ( int theValue )
   {
      ACQ_phase_factor = theValue;
   }
	

   int  getACQ_phase_factor() const
   {
      return ACQ_phase_factor;
   }

   void setDimension ( int theValue )
   {
      Dimension = theValue;
   }
	
   int  getDimension() const
   {
      return Dimension;
   }

   void setFlipAngle ( double theValue )
   {
      FlipAngle = theValue;
   }
	
   double  getFlipAngle() const
   {
   return FlipAngle;
   }

   void setImaginaryPart ( const std::vector< double >& theValue )
   {
      ImaginaryPart = theValue;
   }	

   std::vector< double >  getImaginaryPart() const
   {
      return ImaginaryPart;
   }

   void setNA ( int theValue )
   {
      NA = theValue;
   }	

   int  getNA() const
   {
      return NA;
   }

   void setNR ( int theValue )
   {
      NR = theValue;
   }
	
   int  getNR() const
   {
      return NR;
   }

   void setNumberOfSlices ( int theValue )
   {
      NumberOfSlices = theValue;
   }
	

int  getNumberOfSlices() const
{
   return NumberOfSlices;
}

void setObjectNumber ( int theValue )
{
   ObjectNumber = theValue;
}
	

int  getObjectNumber() const 
{
   return ObjectNumber;
}

void setRealPart ( const std::vector< double >& theValue )
{
   RealPart = theValue;
}
	

std::vector< double >  getRealPart() const
{
   return RealPart;
}

void setRG ( double theValue )
{
   RG = theValue;
}
	

double  getRG() const
{
   return RG;
}

void setRotationMatrixRPS2XYZ ( const std::vector< std :: vector < double > >& theValue )
{
   RotationMatrixRPS2XYZ = theValue;
}
	

std::vector< std :: vector < double > >  getRotationMatrixRPS2XYZ() const
{
   return RotationMatrixRPS2XYZ;
}

void setSliceNumber ( int theValue )
{
   SliceNumber = theValue;
}
	

int  getSliceNumber() const
{
   return SliceNumber;
}

void setSliceThickness ( double theValue )
{
   SliceThickness = theValue;
}
	

double  getSliceThickness() const
{
   return SliceThickness;
}

void setTE ( double theValue )
{
   TE = theValue;
}
	

double  getTE() const
{
   return TE;
}


void setTI ( double theValue )
{
   TI = theValue;
}
	

double  getTI() const
{
   return TI;
}

void setTR ( double theValue )
{
   TR = theValue;
}
	

double getTR() const
{
   return TR;
}

void setTranslationVectorRPS2XYZ ( const std::vector< double >& theValue )
{
   TranslationVectorRPS2XYZ = theValue;
}
	

std::vector< double >  getTranslationVectorRPS2XYZ() const
{
   return TranslationVectorRPS2XYZ;
}

void setDimensionSizes ( const std::vector< int >& theValue )
{
   DimensionSizes = theValue;
}
	

std::vector< int > getDimensionSizes() const
{
   return DimensionSizes;
}

void setFOV ( const std::vector< double >& theValue )
{
	FOV = theValue;
}
	

std::vector< double > getFOV() const
{
   return FOV;
}


bool FillWithObject(BrukerDataSet DataSet, int ObjectNumber);


void setNI ( int theValue )
{
   NI = theValue;
}
	

int getNI() const
{
   return NI;	
}

void setNAE ( int theValue )
{
   NAE = theValue;
}
	

int getNAE() const
{
   return NAE;
}

void setDS ( int theValue )
{
   DS = theValue;
}
	

int getDS() const
{
   return DS;
}

void setACQ_ns_list ( const std::vector< int >& theValue )
{
   ACQ_ns_list = theValue;
}
	

std::vector< int > getACQ_ns_list() const
{
   return ACQ_ns_list;
}

void setACQ_obj_order ( const std::vector< int >& theValue )
{
   ACQ_obj_order = theValue;
}
	

std::vector< int > getACQ_obj_order() const
{
   return ACQ_obj_order;
}

void setACQ_echo_time ( const std::vector< int >& theValue )
{
   ACQ_echo_time = theValue;
}
	
std::vector< int > getACQ_echo_time() const
{
   return ACQ_echo_time;
}
	


private:
    int ObjectNumber;
    int Dimension;
    std::vector <int> DimensionSizes;
    std::vector <int> ACQ_ns_list;
    std::vector <int> ACQ_obj_order;
    std::vector <int> ACQ_echo_time;
    double TE;
    double TR;
    double TI;
    double FlipAngle;
    double RG;
    int NA;
    int ACQ_phase_factor;
    std::vector<std::vector<double> >  RotationMatrixRPS2XYZ;
    std::vector <double> TranslationVectorRPS2XYZ;
    long AbsoluteTimePosition;
    int NR;
    int NI;
    int NAE;
    int DS;
    int NumberOfSlices;
    int SliceNumber;
    std::vector <double> FOV;
    double SliceThickness;
    std::vector<double> RealPart;
    std::vector<double> ImaginaryPart;
};

#endif
