//
// C++ Implementation: brukerobjectvaryingproperties
//
// Description: 
//
//
// Author: denis grenier <denis.grenier@creatis.univ-lyon1.fr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "brukerobjectvaryingproperties.h"
#include "brukerexception.h"


BrukerObjectVaryingProperties::BrukerObjectVaryingProperties()
{
}


BrukerObjectVaryingProperties::~BrukerObjectVaryingProperties()
{
}



void BrukerObjectVaryingProperties::computePositionS(std::map<std::string, BrukerFieldData> & BrukerHM){
   std::vector<double> PosiS =BrukerHM[(std::string) "ACQ_slice_offset"].GetDoubleValue();
   PositionS =PosiS;
};

void BrukerObjectVaryingProperties::computePositionR(std::map<std::string, BrukerFieldData> & BrukerHM){
   PositionR =BrukerHM[(std::string) "ACQ_read_offset"].GetDoubleValue() ;
};

void BrukerObjectVaryingProperties::computePositionP(std::map<std::string, BrukerFieldData> & BrukerHM){
   PositionP =BrukerHM[(std::string) "ACQ_phase1_offset"].GetDoubleValue();
};

void BrukerObjectVaryingProperties::computeTE(std::map<std::string, BrukerFieldData> & BrukerHM){
   TE = BrukerHM[(std::string) "ACQ_echo_time"].GetDoubleValue();
};

double BrukerObjectVaryingProperties::getTE(unsigned int theValue) const{
   if (theValue < TE.size() ) {return TE[theValue];}
   //else throw 0;
   else throw BrukerSizeException("TE", theValue, TE.size() ); 
}

/*void BrukerObjectVaryingProperties::computeTE(const std::vector< double >& theValue)
{
  TE = theValue;
}*/

double  BrukerObjectVaryingProperties::getPositionP(unsigned int theValue) const{
   if (theValue < PositionP.size() ) return PositionP[theValue];
//   else throw 1;
   else throw BrukerSizeException("PositionP", theValue, PositionP.size() );    
}
  
/*void BrukerObjectVaryingProperties::computePositionP(const std::vector< double >& theValue)
{
  PositionP = theValue;
}*/

double  BrukerObjectVaryingProperties::getPositionR(unsigned int theValue) const{
   if (theValue < PositionR.size() ) return PositionR[theValue];
//   else throw 2;
   else throw BrukerSizeException("PositionR", theValue, PositionR.size() );
}

/*void BrukerObjectVaryingProperties::computePositionR(const std::vector< double >& theValue)
{
  PositionP = theValue;
}*/

double  BrukerObjectVaryingProperties::getPositionS(unsigned int theValue) const{
   if (theValue < PositionS.size() )  return PositionS[theValue];
//   else throw 3;
   else throw BrukerSizeException("PositionS", theValue, PositionS.size() );
}

/*void BrukerObjectVaryingProperties::computePositionS(const std::vector< double >& theValue)
{
  PositionP = theValue;
}*/

int  BrukerObjectVaryingProperties::getAcquisitionOrder(unsigned int theValue) const{
   if (theValue <AcquisitionOrder.size())  return AcquisitionOrder[theValue];
   //else throw 4;
   else throw BrukerSizeException("AcquisitionOrder", theValue, AcquisitionOrder.size() );
}

/*void BrukerObjectVaryingProperties::computeAcquisitionOrder(const std::vector< int >& theValue1, const std::vector< int >& theValue2)
{
   AcquisitionOrder.clear();
   if (theValue1.size() != theValue2[3]*theValue2[1]) throw 5;
   if (theValue2.size() < 4 ) throw 6;
   for (int i =0 ;i<theValue2[3];i++)AcquisitionOrder.push_back()=(int) theValue1[i*theValue2[1]]/theValue2[1];
}*/

void BrukerObjectVaryingProperties::computeAcquisitionOrder(std::map<std::string, BrukerFieldData> & BrukerHM, std::vector<int> & LoopStruct){
  std::vector<int> AcqOrder;
  
  if (BrukerHM[(std::string) "ACQ_obj_order"].GetIntValue().size() != LoopStruct[3]*LoopStruct[1]) {
     std::cout << "BrukerHM[(std::string) 'ACQ_obj_order'].GetIntValue().size() " << BrukerHM[(std::string) "ACQ_obj_order"].GetIntValue().size() 
               << " LoopStruct[3] : " << LoopStruct[3] << " * LoopStruct[1] : " << LoopStruct[1] << " = " << LoopStruct[3]*LoopStruct[1] << std::endl;  
     throw 7;
  }
  if (LoopStruct.size() < 4 ) throw 8;
  for (int i =0 ;i<LoopStruct[3];i++)
     AcqOrder.push_back((int) BrukerHM[(std::string) "ACQ_obj_order"].GetIntValue()[i*LoopStruct[1]]/LoopStruct[1]);
  AcquisitionOrder=AcqOrder;
};

std :: vector < std :: vector < double > >  BrukerObjectVaryingProperties::getOrientation(unsigned int theValue) const {
   if (theValue < Orientation.size())return Orientation[theValue];
   //else throw 9;
   else throw BrukerSizeException("Orientation", theValue, Orientation.size() );
}

/*void BrukerObjectVaryingProperties::computeOrientation( std :: vector < double > & theValue1,const std::vector< int >& theValue2)
{
   if (theValue1.size() != theValue2[3]*9) throw 10;
   if (theValue2.size() < 4 ) throw 11;
   int counter=0;
   for(int i=0;i<theValue2[3];i++){
      for(int j=0;j<3;j++){
         for(int k=0;k<3;k++){
            Orientation[i][j][k]=theValue1[counter];
            counter++;
         }
      }
   }
}*/

void BrukerObjectVaryingProperties::computeOrientation(std::map<std::string, BrukerFieldData> & BrukerHM, std::vector<int> & LoopStruct){
   if (BrukerHM[(std::string) "ACQ_grad_matrix"].GetDoubleValue().size() != LoopStruct[3]*9) throw 12;
   if (LoopStruct.size() < 4 ) 
   //throw 13;
      throw BrukerSizeException("LoopStruct", 4, LoopStruct.size() );
      
   std::vector<double> Temp1D(3,0.0);
   std::vector<std::vector<double> > Temp2D;
   std::vector<std::vector<std::vector<double> > > Temp3D;
   int i, j ,k;

   for(i=0;i<3;i++) 
      Temp2D.push_back(Temp1D);
   for (i=0;i<LoopStruct[3];i++) 
      Temp3D.push_back(Temp2D);

   int counter=0;
   for(i=0;i<LoopStruct[3];i++){
      for(j=0;j<3;j++){
         for(k=0;k<3;k++){
            Temp3D[i][j][k]=BrukerHM[(std::string) "ACQ_grad_matrix"].GetDoubleValue()[counter];
            counter++;
         }
     }
   }
   Orientation=Temp3D;
};

double BrukerObjectVaryingProperties::getPositionTimePerNR(unsigned int theValue) const{
   if (theValue <PositionTimePerNR.size() ) return PositionTimePerNR[theValue];
   else throw 14;
}

void BrukerObjectVaryingProperties::computePositionTimePerNR(std::map<std::string, BrukerFieldData> & BrukerHM, std::vector<int> & LoopStruct){
   double FloatPositionTimePerNR=BrukerHM[(std::string) "ACQ_repetition_time"].GetDoubleValue()[0];
   int i=0;
   int NA=BrukerHM[(std::string) "NA"].GetIntValue()[0];
   int NAE=BrukerHM[(std::string) "NAE"].GetIntValue()[0];
   double temp;

/*
 les loop de 0 a 3 ne sont pas concernes par le temps car ils creent presque systematiquement
 un melange temporel des donnees, c'est pour cela que je ne calcule qu'un temps moyen a partir de celles -ci
*/
   for (i=4; i<(LoopStruct.size()-1);i++)
   { 
      FloatPositionTimePerNR=FloatPositionTimePerNR*LoopStruct[i];
   }
   FloatPositionTimePerNR=FloatPositionTimePerNR*NA*NAE/2000.0;
   if (BrukerHM[(std::string) "ACQ_temporal_delay"].GetDoubleValue().size()==1)
   {
      temp=BrukerHM[(std::string)"ACQ_temporal_delay"].GetDoubleValue()[0]/1000.0;
      for (i=1; i<=LoopStruct.back();i++)
      {
         PositionTimePerNR.push_back(FloatPositionTimePerNR+ (2*FloatPositionTimePerNR+temp)*(i-1));
      }
   }

   if (BrukerHM[(std::string) "ACQ_temporal_delay"].GetDoubleValue().size()!=1&& BrukerHM[(std::string) "ACQ_temporal_delay"].GetDoubleValue().size()!=(LoopStruct.back()-1))
   {
      throw 15;
   }
   if (BrukerHM[(std::string) "ACQ_temporal_delay"].GetDoubleValue().size()!=1&& BrukerHM[(std::string) "ACQ_temporal_delay"].GetDoubleValue().size()==(LoopStruct.back()-1))
   {
      PositionTimePerNR[0] = FloatPositionTimePerNR;
      for (int i=1; i<=LoopStruct.back();i++)
      {  
         PositionTimePerNR[i] = PositionTimePerNR[i-1]+ (2*FloatPositionTimePerNR+BrukerHM[(std::string) "ACQ_temporal_delay"].GetDoubleValue()[i-1]/1000.0);
      }
   }
}


/*!
    \fn BrukerObjectVaryingProperties::init(std::map<std::string, BrukerFieldData> BrukerHM,std::vector<int> LoopStruct)
 */
bool BrukerObjectVaryingProperties::init(std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct)
{
   try {
      computeAcquisitionOrder (BrukerHM, LoopStruct);
      computeOrientation      (BrukerHM, LoopStruct);
      computePositionP        (BrukerHM);
      computePositionR        (BrukerHM);
      computePositionS        (BrukerHM);
      computePositionTimePerNR(BrukerHM, LoopStruct);
      computeTE               (BrukerHM);
   }
   catch (int i)
   {
      std::cout << "Failure during BrukerObjectVaryingProperties::init err code : " << i << std::endl;
      if (i==7)
         std::cout << "Probabely non standard acquisition (extra loop not yet dealt with)" << std::endl;
      return false;   
   }   
   catch (...)
   {
      std::cout << "Failure during BrukerObjectVaryingProperties::init " << std::endl;
      return false;
   }
   
   return true;
} 

