//
// C++ Interface: brukerobjectvaryingproperties
//
// Description: 
//
//
// Author: denis grenier <denis.grenier@creatis.univ-lyon1.fr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BRUKEROBJECTVARYINGPROPERTIES_H
#define BRUKEROBJECTVARYINGPROPERTIES_H
#include <cstdlib>
#include <stdlib.h>
#include <string>
#include <iostream>
#include <sstream>
#include <stdio.h>
#include <fstream>
#include <map>
#include <algorithm>
#include "boost/regex.hpp"
#include "brukerFieldData.h"
#include "brukerSystem.h"

/**
	@author denis grenier <denis.grenier@creatis.univ-lyon1.fr>
*/
class  creaBruker_EXPORT BrukerObjectVaryingProperties{
public:	
   BrukerObjectVaryingProperties();
   ~BrukerObjectVaryingProperties();
   
   double getTE               (unsigned int theValue) const;
   double getPositionP        (unsigned int theValue) const;
   double getPositionR        (unsigned int theValue) const;
   double getPositionS        (unsigned int theValue) const;
   double getPositionTimePerNR(unsigned int theValue) const;
   int    getAcquisitionOrder (unsigned int theValue) const;

   std::vector<std::vector<double> > getOrientation(unsigned int theValue) const;

   bool init(std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);

private:

   void computePositionTimePerNR (std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);
   void computeOrientation       (std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);
   void computeAcquisitionOrder  (std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);
   void computePositionS         (std::map<std::string, BrukerFieldData> &BrukerHM);
   void computePositionR         (std::map<std::string, BrukerFieldData> &BrukerHM);
   void computePositionP         (std::map<std::string, BrukerFieldData> &BrukerHM);
   void computeTE                (std::map<std::string, BrukerFieldData> &BrukerHM);
   std::vector<double> TE;
   std::vector<double> PositionR;
   std::vector<double> PositionP;
   std::vector<double> PositionS;
   std::vector<double> PositionTimePerNR;
   std::vector<int>    AcquisitionOrder;
   std::vector<std::vector<std::vector <double> > > Orientation;
};

#endif
