#ifndef __bbPackRecalageCalculateVectorBox_h_INCLUDED__
#define __bbPackRecalageCalculateVectorBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "PlanesOperations.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT CalculateVectorBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(CalculateVectorBox,bbtk::AtomicBlackBox);

  /*Points in X for the first vector (the vector in the first image), this array should have the structure (a,b), "a" being the position in X for the starting point of the vector
	and "b" the position in X for the ending point of the vector */
  BBTK_DECLARE_INPUT(PointsX1,std::vector<int>);
  
  /*Points in X for the second vector (the vector in the second image), this array should have the structure (a,b), "a" being the position in X for the starting point of the vector
	and "b" the position in X for the ending point of the vector */
  BBTK_DECLARE_INPUT(PointsX2,std::vector<int>);

  /*Points in Y for the first vector (the vector in the first image), this array should have the structure (a,b), "a" being the position in Y for the starting point of the vector
	and "b" the position in Y for the ending point of the vector */
  BBTK_DECLARE_INPUT(PointsY1,std::vector<int>);

  /*Points in Y for the second vector (the vector in the second image), this array should have the structure (a,b), "a" being the position in Y for the starting point of the vector
	and "b" the position in Y for the ending point of the vector */
  BBTK_DECLARE_INPUT(PointsY2,std::vector<int>);

  /*Points in Z for the first vector (the vector in the first image), this array should have the structure (a,b), "a" being the position in Z for the starting point of the vector
	and "b" the position in Z for the ending point of the vector */
  BBTK_DECLARE_INPUT(PointsZ1,std::vector<int>);

  /*Points in Z for the second vector (the vector in the second image), this array should have the structure (a,b), "a" being the position in Z for the starting point of the vector
	and "b" the position in Z for the ending point of the vector */
  BBTK_DECLARE_INPUT(PointsZ2,std::vector<int>);

  /*Origin (starting point of the vector) of the second image, this is necesary for the translation matrix of a transform filter*/
  BBTK_DECLARE_OUTPUT(Origin, std::vector<int>);

  /*Origin (starting point of the vector) of the first image, this is necesary for the imageReslicer filter*/
  BBTK_DECLARE_OUTPUT(OriginReslicer, std::vector<int>);
  
  /*The rotation axis (this axis is defined by the cross product of the 2 vectors)*/
  BBTK_DECLARE_OUTPUT(TransformAxis, std::vector<double>);

  /*Scale difference in X*/
  BBTK_DECLARE_OUTPUT(OutScaleX,int);

  /*Scale difference in Y*/
  BBTK_DECLARE_OUTPUT(OutScaleY,int);

  /*Scale difference in Z*/
  BBTK_DECLARE_OUTPUT(OutScaleZ,int);

  /*Rotation Angle*/
  BBTK_DECLARE_OUTPUT(OutAngle,double);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  
	  PlanesOperations *_vector;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CalculateVectorBox,bbtk::AtomicBlackBox);
BBTK_NAME("CalculateVectorBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Box for calculating the cross and point multiplications of 2 vectors");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(CalculateVectorBox,PointsX1,"List of points in X for the first vector",std::vector<int>,"");
BBTK_INPUT(CalculateVectorBox,PointsX2,"List of points in X for the second vector",std::vector<int>,"");
BBTK_INPUT(CalculateVectorBox,PointsY1,"List of points in Y for the first vector",std::vector<int>,"");
BBTK_INPUT(CalculateVectorBox,PointsY2,"List of points in Y for the second vector",std::vector<int>,"");
BBTK_INPUT(CalculateVectorBox,PointsZ1,"List of points in Z for the first vector",std::vector<int>,"");
BBTK_INPUT(CalculateVectorBox,PointsZ2,"List of points in Z for the second vector",std::vector<int>,"");
BBTK_OUTPUT(CalculateVectorBox,Origin,"Points of Origin for the transformation",std::vector<int>,"");
BBTK_OUTPUT(CalculateVectorBox,OriginReslicer,"Points of Origin for the transformation for the Reslicer",std::vector<int>,"");
BBTK_OUTPUT(CalculateVectorBox,TransformAxis,"Axis used for the transformation (Result of Cross multiplication)",std::vector<double>,"");
BBTK_OUTPUT(CalculateVectorBox,OutScaleX,"Difference in scale for X for the cross multiplication",int,"");
BBTK_OUTPUT(CalculateVectorBox,OutScaleY,"Difference in scale for Y for the cross multiplication",int,"");
BBTK_OUTPUT(CalculateVectorBox,OutScaleZ,"Difference in scale for Z for the cross multiplication",int,"");
BBTK_OUTPUT(CalculateVectorBox,OutAngle,"Angle that represents the dot multiplication",double,"");
BBTK_END_DESCRIBE_BLACK_BOX(CalculateVectorBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageCalculateVectorBox_h_INCLUDED__

