#ifndef __bbPackRecalageCheckBoardBox_h_INCLUDED__
#define __bbPackRecalageCheckBoardBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "vtkImageData.h"
#include "CheckBoard.h"
#include "iostream"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT CheckBoardBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(CheckBoardBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1, vtkImageData*);
  BBTK_DECLARE_INPUT(In2, vtkImageData*);
  BBTK_DECLARE_INPUT(Cols, int);
  BBTK_DECLARE_INPUT(Rows, int);
  BBTK_DECLARE_OUTPUT(Out, vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
		CheckBoard *checkboard;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CheckBoardBox,bbtk::AtomicBlackBox);
BBTK_NAME("CheckBoardBox");
BBTK_AUTHOR("Carolina Perez/Ricardo A Corredor");
BBTK_DESCRIPTION("Produces a checkboard effect using the two images and thenumber of rows and columns.");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(CheckBoardBox, In1, "Input Image1", vtkImageData*, "");
BBTK_INPUT(CheckBoardBox, In2, "Input Image2", vtkImageData*, "");
BBTK_INPUT(CheckBoardBox, Cols, "Number of partitions for the X axis (columns)", int, "");
BBTK_INPUT(CheckBoardBox, Rows, "Number of partitions for the Y axis (rows)", int, "");
BBTK_OUTPUT(CheckBoardBox, Out, "Output Image", vtkImageData*, "");
BBTK_END_DESCRIBE_BLACK_BOX(CheckBoardBox);
}
// EO namespace bbPackVisuImages

#endif // __bbPackVisuImagesCheckBoardBox_h_INCLUDED__

