#ifndef __bbPackRecalageDuplicateImageBox_h_INCLUDED__
#define __bbPackRecalageDuplicateImageBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT DuplicateImageBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(DuplicateImageBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(DuplicateImageBox,bbtk::AtomicBlackBox);
BBTK_NAME("DuplicateImageBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Creates a shallow copy of its image input");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(DuplicateImageBox,In,"Original Image",vtkImageData*,"");
BBTK_OUTPUT(DuplicateImageBox,Out,"Duplicated Image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(DuplicateImageBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageDuplicateImageBox_h_INCLUDED__

