#include "bbPackRecalageImageConvolution.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ImageConvolution)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageConvolution,bbtk::AtomicBlackBox);
void ImageConvolution::Process()
{
	if(convolution != NULL && bbGetInputIn() != NULL)
	{
		convolution->setImage(bbGetInputIn());
		convolution->setFactor(bbGetInputFactor());
		convolution->setOn(bbGetInputOn());
		convolution->Run();
		bbSetOutputOut(convolution->getImage());
	}
}

void ImageConvolution::bbUserSetDefaultValues()
{
	bbSetInputIn(NULL);
	bbSetOutputOut(NULL);
	bbSetInputFactor(5.0);
	bbSetInputOn(false);
}

void ImageConvolution::bbUserInitializeProcessing()
{
	convolution = new Convolution();  
}
void ImageConvolution::bbUserFinalizeProcessing()
{
	delete convolution;
}
}
// EO namespace bbPackRecalage