#include "bbPackRecalageImageRecalageProperties.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ImageRecalageProperties)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageRecalageProperties,bbtk::AtomicBlackBox);
void ImageRecalageProperties::Process()
{
	image = bbGetInputIn();
	if(image != NULL)
	{
		bbSetOutputLengthZ((int)image->GetDimensions()[2] - 1);
		
		if(image->GetScalarType() == VTK_DOUBLE)
		{
				bbSetOutputColorLevel(50);
				bbSetOutputMidColorLevel(25);
		}
		else
		{
				bbSetOutputColorLevel(255);
				bbSetOutputMidColorLevel(127.5);
		}
	}
}
void ImageRecalageProperties::bbUserSetDefaultValues()
{ 
   bbSetInputIn(NULL);
   image = NULL;  
}
void ImageRecalageProperties::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
 
  
}
void ImageRecalageProperties::bbUserFinalizeProcessing()
{
	image->Delete();
}
}
// EO namespace bbPackRecalage