#ifndef __bbPackRecalagePlaneReorientationBox_h_INCLUDED__
#define __bbPackRecalagePlaneReorientationBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "vtkTransform.h"
#include "vtkMath.h"
#include "vtkMatrix4x4.h"
#include "PlaneReorientation.h"
#include <string>

#include "iostream"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT PlaneReorientationBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(PlaneReorientationBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(InX,std::vector<int>);
  BBTK_DECLARE_INPUT(InY,std::vector<int>);
  BBTK_DECLARE_INPUT(InZ,std::vector<int>);
  BBTK_DECLARE_INPUT(labels,std::vector<std::string>);
  BBTK_DECLARE_INPUT(CenterPoint,std::vector<int>);
  BBTK_DECLARE_OUTPUT(Out,vtkTransform*);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  vtkTransform *transform;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(PlaneReorientationBox,bbtk::AtomicBlackBox);
BBTK_NAME("PlaneReorientationBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Reorientates an image by use of a plane");
BBTK_CATEGORY("filter");
BBTK_INPUT(PlaneReorientationBox,InX,"Points in X (for all the three points)",std::vector<int>,"");
BBTK_INPUT(PlaneReorientationBox,InY,"Points in Y (for all the three points)",std::vector<int>,"");
BBTK_INPUT(PlaneReorientationBox,InZ,"Points in Z (for all the three points)",std::vector<int>,"");
BBTK_INPUT(PlaneReorientationBox,labels,"Labels of the points",std::vector<std::string>,"");
BBTK_INPUT(PlaneReorientationBox,CenterPoint,"CenterPoint",std::vector<int>,"");
BBTK_OUTPUT(PlaneReorientationBox,Out,"Transformation ",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(PlaneReorientationBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalagePlaneNormalBox_h_INCLUDED__

