#include "bbPackRecalageReSlicerBox.h"
#include "bbPackRecalagePackage.h"

namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ReSlicerBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ReSlicerBox,bbtk::AtomicBlackBox);
void ReSlicerBox::Process()
{
	if(!bbGetInputOrigin().empty()  && bbGetInputTransform() != NULL)
	{
		//image = vtkImageChangeInformation::New();
		image->SetInput( bbGetInputIn() );
		image->SetOutputSpacing( 1,1,1 );

		if(bbGetInputCentered())
		{
			image->CenterImageOn();
		}

		//slicer =vtkImageReslice::New();
		slicer->SetInput( image->GetOutput() );
		slicer->SetInformationInput( image->GetOutput() );
		slicer->SetResliceTransform(bbGetInputTransform());
 		slicer->SetOutputOrigin( -(bbGetInputOrigin()[0]) , -(bbGetInputOrigin()[1]) , -(bbGetInputOrigin()[2]) );
		if(bbGetInputInterpolate())
		{
			slicer->InterpolateOn();
		}		
		slicer->Update();

		//imageResult = vtkImageChangeInformation::New();
		imageResult->SetInput( slicer->GetOutput() );
		double spc[3];
		bbGetInputIn()->GetSpacing(spc);
		imageResult->SetOutputSpacing( spc ); 
		imageResult->SetOutputOrigin( 0,0,0 ); 
	
		bbSetOutputOut( imageResult->GetOutput() );
	}
	else
	{
		bbSetOutputOut( NULL );
	}  
}
void ReSlicerBox::bbUserSetDefaultValues()
{ 
	std::vector<int> empty;
	bbSetInputOrigin(empty); 
    bbSetInputIn(NULL); 
    bbSetInputTransform(NULL);
    bbSetOutputOut(NULL);
	bbSetInputCentered(false);
	bbSetInputInterpolate(false);
  
}
void ReSlicerBox::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
	image = vtkImageChangeInformation::New();
    slicer =vtkImageReslice::New();
	imageResult = vtkImageChangeInformation::New();
}
void ReSlicerBox::bbUserFinalizeProcessing()
{ 
	image->Delete();
	slicer->Delete();
    imageResult->Delete();
}
}
// EO namespace bbPackRecalage