#include "bbPackRecalageResampleBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage, ResampleBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ResampleBox, bbtk::AtomicBlackBox);
void ResampleBox::Process()
{
    if(bbGetInputIn() != NULL && bbGetInputFactor() != 0)
	{
		double factor = bbGetInputFactor();
		resample->SetInput(bbGetInputIn());
		resample->SetAxisMagnificationFactor(0, factor);
		resample->SetAxisMagnificationFactor(1, factor);
		resample->SetAxisMagnificationFactor(2, factor);
		resample->Update();
		vtkImageData *image = resample->GetOutput();
		std::cout << "NTU: new spacing!" << image->GetExtent()[1] << " " << image->GetExtent()[3] << " " << image->GetExtent()[5] << " " << image->GetSpacing()[0] << " " << image->GetSpacing()[1] << " " << image->GetSpacing()[2] << std::endl;
		bbSetOutputOut(resample->GetOutput());
	}
	else
	{
		bbSetOutputOut(NULL);
	}
}

void ResampleBox::bbUserSetDefaultValues()
{
    bbSetInputIn(NULL);
	bbSetInputFactor(0);
	bbSetOutputOut(NULL);
}

void ResampleBox::bbUserInitializeProcessing()
{
	resample = vtkImageResample::New();
}

void ResampleBox::bbUserFinalizeProcessing()
{
	resample->Delete(); 
}

}
// EO namespace bbPackRecalage


