#include "bbPackRecalageSurfaceCreator.h"
#include "bbPackRecalagePackage.h"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

#include "vtkActorCollection.h"

namespace bbPackRecalage
{



BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,SurfaceCreator)
BBTK_BLACK_BOX_IMPLEMENTATION(SurfaceCreator,bbtk::AtomicBlackBox);
void SurfaceCreator::Process()
{
    surface1 = new Surface(bbGetInputImage1(),bbGetInputHeight1(),bbGetInputColor1());
	surface2 = new Surface(bbGetInputImage2(),bbGetInputHeight2(),bbGetInputColor2());

	if(firsttime == true)
	{
        bbSetOutputOut1(surface1->getSurface());
		bbSetOutputOut2(surface2->getSurface());
	}   

	if (bbGetInputRenderer()!=NULL)
     {       
	   firsttime = false;

	   bbGetInputRenderer()->RemoveAllViewProps();	   

       bbGetInputRenderer()->AddActor( surface1->getSurface());
	   bbGetInputRenderer()->AddActor( surface2->getSurface());

	   bbGetInputRenderer()->Render();
     }  
}
void SurfaceCreator::bbUserSetDefaultValues()
{
 
//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX  
//    Here we initialize the input 'In' to 0 
    firsttime=true;
	bbSetInputImage1(NULL);
	bbSetInputHeight1(0);
	bbSetInputColor1("");
	bbSetInputImage2(NULL);
	bbSetInputHeight2(0);
	bbSetInputColor2("");
	bbSetInputRenderer(NULL);
  
}
void SurfaceCreator::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
 
  
}
void SurfaceCreator::bbUserFinalizeProcessing()
{
 
//  THE FINALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should desallocate the internal/output pointers  
//    if any 

	delete surface1;
	delete surface2;
  
}
}
// EO namespace bbCreaRecalage


