#include "bbPackRecalageTransform2DBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,Transform2DBox)
BBTK_BLACK_BOX_IMPLEMENTATION(Transform2DBox,bbtk::AtomicBlackBox);
void Transform2DBox::Process()
{
	if(!bbGetInputCenterPoint().empty())
		{
			//	The inputs are set in the library transformer
			transformer->SetCenterPoint( bbGetInputCenterPoint() );
			transformer->SetAngle( bbGetInputAngle() );
			transformer->SetScaleX( bbGetInputScaleX() );
			transformer->SetScaleY( bbGetInputScaleY() );
			transformer->SetScaleZ( bbGetInputScaleZ() );

			// The calculation of the transformations are made
  			transformer->Run();
			// We get the results of transformer and set it as result of this box
			bbSetOutputOut( transformer->GetResult() );			
		}
		else
		{
			bbSetOutputOut( NULL );
		}
  
}
void Transform2DBox::bbUserSetDefaultValues()
{
		//We initialize the points with an empty vector, the angle in 0 and the scales in 1   
		std::vector<int> nuevo(3,0);
		nuevo.push_back(0);
		bbSetInputCenterPoint(nuevo); 
		bbSetInputAngle(0); 
		bbSetInputScaleX(100);
		bbSetInputScaleY(100);
		bbSetInputScaleZ(100);
		bbSetOutputOut(NULL);		
  
}
void Transform2DBox::bbUserInitializeProcessing()
{
		//We initialize the transformer
		transformer=new Transformer();
 
  
}
void Transform2DBox::bbUserFinalizeProcessing()
{
		//We delete the transformer
		delete transformer;
  
}
}
// EO namespace bbPackRecalage