#ifndef __bbPackRecalageTransform2DBox_h_INCLUDED__
#define __bbPackRecalageTransform2DBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkLinearTransform.h"
#include "Transformer.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT Transform2DBox
 : 
   public bbtk::AtomicBlackBox
{
		BBTK_BLACK_BOX_INTERFACE(Transform2DBox,bbtk::AtomicBlackBox);
		/*Point(x,y) -> Rotation Center*/
		BBTK_DECLARE_INPUT(CenterPoint,std::vector<int>);

		/*Rotation angle*/
		BBTK_DECLARE_INPUT(Angle,double);

		
		/*Scalation to be done in the x axis*/
		BBTK_DECLARE_INPUT(ScaleX,double);

		
		/*Scalation to be done in the y axis*/
		BBTK_DECLARE_INPUT(ScaleY,double);

		/*Scalation to be done in the z axis*/
		BBTK_DECLARE_INPUT(ScaleZ,double);

		/*Resultant vtkTransform*/
		BBTK_DECLARE_OUTPUT(Out, vtkTransform*);

		BBTK_PROCESS(Process);
		void Process();
		
		/*Class in charge of making the transformations*/
		Transformer *transformer;		
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Transform2DBox,bbtk::AtomicBlackBox);
BBTK_NAME("Transform2DBox");
BBTK_AUTHOR("va-perez@uniandes.edu.co");
BBTK_DESCRIPTION("Given 2 points and an angle, it calculates the vtkTransform result after aplying the transformations, using the first point as base of the transformation");
BBTK_CATEGORY("filter");
BBTK_INPUT(Transform2DBox,CenterPoint,"Point (x,y,z) -> Rotation Center",std::vector<int>,"");
BBTK_INPUT(Transform2DBox,Angle,"Rotation Angle",double,"");
BBTK_INPUT(Transform2DBox,ScaleX,"Scale in X",double,"");
BBTK_INPUT(Transform2DBox,ScaleY,"Scale in Y",double,"");
BBTK_INPUT(Transform2DBox,ScaleZ,"Scale in Z",double,"");
BBTK_OUTPUT(Transform2DBox,Out,"Linear Transform filter",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(Transform2DBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageTransform2DBox_h_INCLUDED__

