#include "bbPackRecalageTransform3D1PointBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,Transform3D1PointBox)
BBTK_BLACK_BOX_IMPLEMENTATION(Transform3D1PointBox,bbtk::AtomicBlackBox);
void Transform3D1PointBox::Process()
{
	if(!bbGetInputCenterPoint().empty())
	{
		//	The inputs are set in the library transformer
		transformer->SetCenterPoint( bbGetInputCenterPoint() );
		transformer->SetAngleX( bbGetInputAngleX() );
		transformer->SetAngleY( bbGetInputAngleY() );
		transformer->SetAngleZ( bbGetInputAngleZ() );
		transformer->SetScaleX( bbGetInputScaleX() );
		transformer->SetScaleY( bbGetInputScaleY() );
		transformer->SetScaleZ( bbGetInputScaleZ() );

		// The calculation of the transformations are made
  		transformer->Run();
		// We get the results of transformer and set it as result of this box
		bbSetOutputOut( transformer->GetResult() );			
	}
	else
	{
		bbSetOutputOut( NULL );
	}
}
void Transform3D1PointBox::bbUserSetDefaultValues()
{
	//We initialize the points with an empty vector, the angle in 0 and the scales in 1   
	std::vector<int> nuevo(3,0);
	nuevo.push_back(0);
	bbSetInputCenterPoint(nuevo); 
	bbSetInputAngleX(0);
	bbSetInputAngleY(0);
	bbSetInputAngleZ(0);
	bbSetInputScaleX(100);
	bbSetInputScaleY(100);
	bbSetInputScaleZ(100);
	bbSetOutputOut(NULL);
}
void Transform3D1PointBox::bbUserInitializeProcessing()
{
	//We initialize the transformer
	transformer = new Transformer3D1Point();
}
void Transform3D1PointBox::bbUserFinalizeProcessing()
{
	delete transformer;
}
}
// EO namespace bbPackRecalage


