#ifndef __bbPackRecalageTransparencyV2_h_INCLUDED__
#define __bbPackRecalageTransparencyV2_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"
#include "Transparency.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT TransparencyBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TransparencyBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(Percent,int);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  Transparency *transparency;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TransparencyBox,bbtk::AtomicBlackBox);
BBTK_NAME("TransparencyBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Transparency between two images");
BBTK_CATEGORY("filter");
BBTK_INPUT(TransparencyBox,In1,"First image for transparency",vtkImageData*,"");
BBTK_INPUT(TransparencyBox,In2,"Second image for transparency",vtkImageData*,"");
BBTK_INPUT(TransparencyBox,Percent,"Percent of transparency for the second image",int,"");
BBTK_OUTPUT(TransparencyBox,Out,"Output Image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(TransparencyBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageTransparencyV2_h_INCLUDED__

