#include "CheckBoard.h"

/*
* Constructor
*/
//------------------------------------------------------------
CheckBoard::CheckBoard() :		
	image1(NULL),
	image2(NULL),
	squaresX(0),
	squaresY(0),
	newImage(NULL),
	processed(false),
	resample(NULL),
	result(NULL)
{
/*
	image1=NULL;
	image2=NULL;
	squaresX=0;
	squaresY=0;
	newImage = NULL;
	processed=false;
	newImage = NULL;
	resample = NULL;
	result = NULL;
*/
}

/*
* Destructor
*/
//------------------------------------------------------------
CheckBoard::~CheckBoard()
{
	//if (image1 != NULL ) { image1->Delete(); }
	//if (image2 != NULL ) { image2->Delete(); }
	if (newImage != NULL ) { newImage->Delete(); }
	if (result   != NULL ) { result->Delete();   }
}

//------------------------------------------------------------
void CheckBoard::calculateImage()
{

	if(image1!=NULL && image2!=NULL)
	{
		// IMAGE 1
			
		// Information from image1
		image1->GetSpacing(spcImg1);
		image1->GetExtent(extImg1);

		type = image1->GetScalarType();

		// The Z dimension is 1 for a 2D image
		dimImg1[0] = extImg1[1] - extImg1[0]+1;
		dimImg1[1] = extImg1[3] - extImg1[2]+1;
		dimImg1[2] = 1;

		//IMAGE 2

		// Information from image2
		image2->GetSpacing(spcImg2);
		image2->GetExtent(extImg2);
		
		// The Z dimension is 1 for a 2D image
		dimImg2[0] = extImg2[1] - extImg2[0]+1;
		dimImg2[1] = extImg2[3] - extImg2[2]+1;
		dimImg2[2] = 1;

		long numPixelsImg1 = dimImg1[0]*dimImg1[1];
		long numPixelsImg2 = dimImg2[0]*dimImg2[1];

		double factorX = 1;
		double factorY = 1;
		resample = vtkImageResample::New();
		result = vtkImageData::New();
		if(numPixelsImg1<numPixelsImg2)
		{
			resample->SetInput(image1);
			factorX = (double)extImg2[1]/extImg1[1];
			factorY = (double)extImg2[3]/extImg1[3];
			resample->SetAxisMagnificationFactor(0,factorX);
			resample->SetAxisMagnificationFactor(1,factorY);
			resample->SetInformationInput(image2);

			initialize(dimImg2, spcImg2);
			result = resample->GetOutput();
			result->Update();
			createImage(result,image2,dimImg2[0],dimImg2[1]);		
		} //if
		else if (numPixelsImg1>numPixelsImg2)
		{
			resample->SetInput(image2);
			factorX = (double)extImg1[1]/extImg2[1];
			factorY = (double)extImg1[3]/extImg2[3];
			resample->SetAxisMagnificationFactor(0,factorX);
			resample->SetAxisMagnificationFactor(1,factorY);
			resample->SetInformationInput(image1);

			initialize(dimImg1, spcImg1);
			result = resample->GetOutput();

			result->Update();

			createImage(image1,result,dimImg1[0],dimImg1[1]);
		} // else if
		else
		{
			//If both images have the same number of pixels, the resultant image will have the 
			//properties of the first image.
			resample->SetInput(image2);
			factorX = (double)extImg1[1]/extImg2[1];
			factorY = (double)extImg1[3]/extImg2[3];
			resample->SetAxisMagnificationFactor(0,factorX);
			resample->SetAxisMagnificationFactor(1,factorY);
			resample->SetInformationInput(image1);

			initialize(dimImg1, spcImg1);

			result = resample->GetOutput();
			result->Update();

			createImage(image1,result,dimImg1[0],dimImg1[1]);

		} //else

		resample->Delete();		
		processed=true;
	}
}

//------------------------------------------------------------
void CheckBoard::initialize(int dimensions[], double spacing[])
{
	// Setting the new image
	if(newImage != NULL){
			newImage->Delete();
	}
	newImage = vtkImageData::New();
	newImage->SetScalarType(type);
	newImage->SetSpacing(spacing);
	newImage->SetDimensions(dimensions);
	newImage->AllocateScalars();
	newImage->Update();
}

//------------------------------------------------------------
void CheckBoard::createImage(vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY)
{
	int imageType=img1->GetScalarType();

	if(imageType == VTK_CHAR)
	{
		//POINTERS: 
		char* dataImagePointer1 = NULL;
		char* dataImagePointer2 = NULL;
		char* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_SIGNED_CHAR)
	{
		//POINTERS: 
		signed char* dataImagePointer1 = NULL;
		signed char* dataImagePointer2 = NULL;
		signed char* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_UNSIGNED_CHAR)
	{
		//POINTERS: 
		unsigned char* dataImagePointer1 = NULL;
		unsigned char* dataImagePointer2 = NULL;
		unsigned char* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_SHORT)
	{
        //POINTERS: 
		short* dataImagePointer1 = NULL;
		short* dataImagePointer2 = NULL;
		short* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_UNSIGNED_SHORT)
	{
		//POINTERS: 
		unsigned short* dataImagePointer1 = NULL;
		unsigned short* dataImagePointer2 = NULL;
		unsigned short* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}

	else if(imageType == VTK_INT)
	{
		//POINTERS: 
		int* dataImagePointer1 = NULL;
		int* dataImagePointer2 = NULL;
		int* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_UNSIGNED_INT)
	{
		//POINTERS: 
		unsigned int* dataImagePointer1 = NULL;
		unsigned int* dataImagePointer2 = NULL;
		unsigned int* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_LONG)
	{
		//POINTERS: 
		long* dataImagePointer1 = NULL;
		long* dataImagePointer2 = NULL;
		long* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_UNSIGNED_LONG)
	{
		//POINTERS: 
		unsigned long* dataImagePointer1 = NULL;
		unsigned long* dataImagePointer2 = NULL;
		unsigned long* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_FLOAT)
	{
		//POINTERS: 
		float* dataImagePointer1 = NULL;
		float* dataImagePointer2 = NULL;
		float* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}
	else if(imageType == VTK_DOUBLE)
	{
		//POINTERS: 
		double* dataImagePointer1 = NULL;
		double* dataImagePointer2 = NULL;
		double* dataImageResultPointer = NULL;

		createImageByType(dataImagePointer1,dataImagePointer2,dataImageResultPointer,img1,img2,sizeX,sizeY);
	}

	//std::cout << "The image has been checkboardized!" << std::endl;
   newImage->Update();
//   newImage->Modified();
}
/**Template used for the different image types
*/
template <class T>
void CheckBoard::createImageByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY)
{
	dataImagePointer1 = (T*) img1->GetScalarPointer(0,0,0);
	dataImagePointer2 = (T*) img2->GetScalarPointer(0,0,0);
	dataImageResultPointer = (T*) newImage->GetScalarPointer(0,0,0);

	if(squaresX == 0)
	{
		squaresX = 1;
	}
	if(squaresY == 0)
	{
		squaresY = 1;
	}

	int divX = sizeX/squaresX;
	int divY = sizeY/squaresY;
	int i, j;
	int counterX=0, counterY;  // JPR : uninitialized
	for(i = 0; i < sizeX; i++)
	{
		counterY = 0; 
		for(j = 0; j < sizeY; j++)
		{
			dataImagePointer1 = (T*)img1->GetScalarPointer(i,j,0);
			dataImagePointer2 = (T*)img2->GetScalarPointer(i,j,0);
			dataImageResultPointer = (T*)newImage->GetScalarPointer(i,j,0);
			if( (counterX <= divX && counterY <= divY) || ((counterX >= divX && counterX <= 2*divX) && (counterY >= divY && counterY <= 2*divY)) )
			{
				*dataImageResultPointer = (T) *dataImagePointer1;
			}
			else //if( ((counterX >= divX && counterX <= 2*divX) && counterY <= divY) || (counterX <= divX && (counterY >= divY && counterY <= 2*divY)) )
			{
				*dataImageResultPointer = (T) *dataImagePointer2;
			}

			if(counterX >= 2*divX)
			{
				counterX = 0;
			}
			else if(counterY >= 2*divY)
			{
				counterY = 0;
			}			
			counterY++;
		}
		counterX++;
	}
}

/*
* Get new image
*/
//------------------------------------------------------------
vtkImageData* CheckBoard::getFilteredImage()
{
	if(processed){
		return newImage;
	}
	else{
		return NULL;
	}
}

//------------------------------------------------------------
void CheckBoard::setInputImage1(vtkImageData *_image)
{
	image1=_image;
}

//------------------------------------------------------------
void CheckBoard::setInputImage2(vtkImageData *_image)
{
	image2=_image;
}

//------------------------------------------------------------
void CheckBoard::setCols(int cols)
{
	squaresX=cols;
}

//------------------------------------------------------------
void CheckBoard::setRows(int rows)
{
	squaresY=rows;
}
