#include "Convolution.h"

/*
* Constructor
*/
//------------------------------------------------------------
Convolution::Convolution()
{
	_image=NULL;
	_convolve = vtkImageConvolve::New();
	_cast = vtkImageCast::New();
}

/*
* Destructor
*/
//------------------------------------------------------------
Convolution::~Convolution()
{
	if (_convolve != NULL ) { _convolve->Delete(); }
	if (_cast != NULL ) { _cast->Delete(); }
}

vtkImageData *Convolution::getImage()
{
	return _cast->GetOutput();
}

void Convolution::setImage(vtkImageData *image)
{
	_image = image;
	_convolve->SetInput(_image);
}

void Convolution::setFactor(double factor)
{
	_factor = (factor/100.0)*5.0;	
}

void Convolution::setOn(bool on)
{
	_on = on;
}

void Convolution::Run()
{
	if(_on)
	{
		double kernel[] = {0.0,1.0,0.0,1.0,-_factor,1.0,0.0,1.0,0.0};
		_convolve->SetKernel3x3(kernel);
		_convolve->Update();
		_cast->SetInput(_convolve->GetOutput());
		//_cast->SetOutputScalarTypeToDouble();
		_cast->Update();
	}
	else
	{
		_cast->SetInput(_image);
		_cast->SetOutputScalarType(_image->GetScalarType());
		_cast->Update();
	}	
}