#include "vtkImageData.h"
#include "vtkImageConvolve.h"
#include "vtkImageCast.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>

class Convolution
{
	public:	
		Convolution();
		~Convolution();

		//Gets the result
		vtkImageData* getImage();
		
		void setImage(vtkImageData *image);
		void setFactor(double factor);
		void setOn(bool on);

		void Run();
		
	// --- Atributes --- //
	private: 

		//Original Image
		vtkImageData *_image;

		//Convolution factor
		double _factor;

		//Convolution Filter
		vtkImageConvolve *_convolve;

		//Casting Filter
		vtkImageCast *_cast;

		bool _on;
};

