#include "vtkTransform.h"
#include "vtkMath.h"
#include "vtkMatrix4x4.h"
#include <string>
#include "vector"

#include "iostream"

class PlaneReorientation
{
	public:
		//------------------//
		//Constructors
		//------------------//
		PlaneReorientation();
		~PlaneReorientation();

		void SetVectors(std::vector<int> pointsX, std::vector<int> pointsY, std::vector<int> pointsZ, std::vector<std::string> labels);
		void CalculateNormal();
		vtkTransform* getTransform();

		void Run();

	private:
		vtkTransform *_transform;
		double a[3];
		double b[3];
		double o[3];

		double normal[3];		
};