#include "vtkImageData.h"

#include <string>
#include <vector>

class Substraction 
{

	//----------------------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------------------
	public:
	//--------------------------
	//Constructor & Destructor
	//--------------------------		
		Substraction(vtkImageData* imageData1, vtkImageData* imageData2, int uZLevel,int lZLevel, std::vector<double> uColor, std::vector<double> lColor, std::vector<double> mColor);
		~Substraction();
	//--------------------------
	//Methods
	//--------------------------
		/*
		getting ready the points
		*/
		void initialize(int dimensions[],double spacing[]);
		/*
		Calculate the new image and save it in the attribute imageResult
		it is used if the user had given the imageData
		*/
		void substractImage(vtkImageData* imageData1, vtkImageData* imageData2);
		
		/*
		Returns the ImageResult
		*/
		vtkImageData* getSubstractedImage();
		
		/*
		 Get Image Size
		*/
		int getImageSize();
		
		/*
		constructing image substract
		*/
		void substract(vtkImageData* imageData1, vtkImageData* imageData2);

		/*
		Template method of substract for different image types
		*/
		template <class T> void substractByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *imageData1, vtkImageData *imageData2);
		


	//----------------------------------------------------------------------------------------
	// Attributes declaration
	//----------------------------------------------------------------------------------------
	private: 
		/*
		 Substracted Image
		*/
		vtkImageData* imageResult;
		/*
		 image size dimx*dimy*dimz
		*/
		int sizeImage;
		/*
		upper zero level for doing the Substraction
		*/
		int uZeroLevel;
		/*
		lower zero level for doing the Substraction
		*/
		int lZeroLevel;
		/*
		Color for the upper threshold
		*/
		int upperColor[3];
		/*
		Color for the lower threshold
		*/
		int lowerColor[3];
		/*
		Color for the medium threshold
		*/
		int mediumColor[3];
		/*
		Image type
		*/
		int imageType;
};

