#include "vtkImageData.h"
#include "vtkImageCast.h"
#include "vtkActor.h"
#include "vtkPolyDataMapper.h"
#include "vtkPolyData.h"
#include "vtkProperty.h"
#include "vtkFloatArray.h"
#include "vtkType.h"
#include "vtkDataSetMapper.h"

#include "Surface.h"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

Surface::Surface(vtkImageData* imageData, int ZHeight, std::string iColor)
{
	surfaceResult= vtkActor::New();
	height=ZHeight;
	color=iColor;	
	//Original image type this case is an unsigned char (3)
	imageType=imageData->GetScalarType();

	//substracting the image
	createSurface(imageData);
}

Surface::~Surface()
{
	if(surfaceResult!=NULL)surfaceResult->Delete();
}

//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------


/*
Calculate the new image and save it in the attribute imageResult
it is used if the user had given the imageData
*/
void Surface::createSurface(vtkImageData* imageData)
{
	//dimensions of the image (extent)
	int ext[6];
	//setting the dimensionality (1d or 2d or 3d )
    int newDim[3];
	//image spacing
    double spc[3];
  
	//getting the information from the original image
	imageData->GetSpacing(spc);
	imageData->GetExtent(ext);
	
	//this a 2d image
	newDim[0]=ext[1]-ext[0]+1;
    newDim[1]=ext[3]-ext[2]+1;
    newDim[2]=1;// in general it is ext[5]-ext[4]+1


	//initializing the image that represents the substracted image
	//initialize(newDim,spc);
	//Time to substract
	surface(imageData);	
}

/*
	 Setting the values for the
*/
void Surface::surface(vtkImageData* imageData)
{
	/*
		images pointers
	*/
	surfacePoints = vtkPoints::New();
	surfaceCells = vtkCellArray::New();
	
	if(imageType == VTK_CHAR)
	{
		// pointers to get into the image
		char* dataImagePointer=NULL;
		
		char max = VTK_CHAR_MAX;

		surfaceByType(dataImagePointer, imageData, max);
	}		
	else if(imageType == VTK_SIGNED_CHAR)
	{
		// pointers to get into the image
		signed char* dataImagePointer=NULL;

		signed char max = VTK_SIGNED_CHAR_MAX;

		surfaceByType(dataImagePointer, imageData, max);	
	}
	else if(imageType == VTK_UNSIGNED_CHAR)
	{
		// pointers to get into the image
		unsigned char* dataImagePointer=NULL;

		unsigned char max = VTK_UNSIGNED_CHAR_MAX;

		surfaceByType(dataImagePointer, imageData, max);	
	}
	else if(imageType == VTK_SHORT)
	{
		// pointers to get into the image
		short* dataImagePointer=NULL;

		short max = VTK_SHORT_MAX;

		surfaceByType(dataImagePointer, imageData, max);	
	}
	else if(imageType == VTK_UNSIGNED_SHORT)
	{
		// pointers to get into the image
		unsigned short* dataImagePointer=NULL;

		unsigned short max = VTK_UNSIGNED_SHORT_MAX;

		surfaceByType(dataImagePointer, imageData, max);	
	}
	else if(imageType == VTK_INT)
	{
		// pointers to get into the image
		int* dataImagePointer=NULL;
		
		int max = VTK_INT_MAX;

		surfaceByType(dataImagePointer, imageData, max);
	}
	else if(imageType == VTK_UNSIGNED_INT)
	{
		// pointers to get into the image
		unsigned int* dataImagePointer=NULL;
		
		unsigned int max = VTK_UNSIGNED_INT_MAX;

		surfaceByType(dataImagePointer, imageData, max);
	}
	else if(imageType == VTK_LONG)
	{
		// pointers to get into the image
		long* dataImagePointer=NULL;
		
		long max = VTK_LONG_MAX;

		surfaceByType(dataImagePointer, imageData, max);
	}
	else if(imageType == VTK_UNSIGNED_LONG)
	{
		// pointers to get into the image
		unsigned long* dataImagePointer=NULL;

		unsigned long max = VTK_UNSIGNED_LONG_MAX;

		surfaceByType(dataImagePointer, imageData, max);	
	}
	else if(imageType == VTK_FLOAT)
	{		
		// pointers to get into the image
		float* dataImagePointer=NULL;

		float max = VTK_FLOAT_MAX;

		surfaceByType(dataImagePointer, imageData, max);	
	}
	else if(imageType == VTK_DOUBLE)
	{
		// pointers to get into the image
		double* dataImagePointer=NULL;

		double max = VTK_DOUBLE_MAX;

		surfaceByType(dataImagePointer, imageData, max);
	}

	vtkPolyData* surfaceData = vtkPolyData::New();
	surfaceData->SetPolys(surfaceCells);
	surfaceData->SetPoints(surfacePoints);
	surfaceData->Update();

	vtkPolyDataMapper* surfaceMapper = vtkPolyDataMapper::New();
	surfaceMapper->SetInput(surfaceData);
	surfaceMapper->Update();

    surfaceResult->SetMapper(surfaceMapper);
	surfaceResult->GetProperty()->SetOpacity(1.0);

	if (color == "RED")
	{
		surfaceResult->GetProperty()->SetColor(1,0,0);
	}
	else if (color == "BLUE")
	{
		surfaceResult->GetProperty()->SetColor(0,0,1);
	}
	else if (color == "GREEN")
	{
		surfaceResult->GetProperty()->SetColor(0,1,0);
	}
	else
	{
		surfaceResult->GetProperty()->SetColor(1,1,1);
	}
}

/*
Template for constructing the surface by image type
*/
template <class T>
void Surface::surfaceByType(T* dataImagePointer, vtkImageData* imageData, T max)
{
	int counter=0;
	
	// we start where the  image starts
	dataImagePointer=(T*)imageData->GetScalarPointer(0,0,0);	
	
	/*
	 Image Size
	*/
	int ext[6];
	imageData->GetExtent(ext);
	int sx,sy,sz;
	sx=ext[1]-ext[0]+1;
	sy=ext[3]-ext[2]+1;
	sz=ext[5]-ext[4]+1;

	//-----------------
	//A3
	//-----------------
	//walking in the image
	int i=0,j=0,k=0;
	double sum1=0;  
	//double sum2=0,sum3=0,sum4=0;	// JPR : unused
	for(i=0;i<sx;i++)
	{
		for(j=0;j<sy;j++)
		{
			for(k=0;k<sz;k++)
			{
				
				// we get the pointer to the position (i,j,k)y that way we can get the position of the point in the surface
				dataImagePointer=(T*)imageData->GetScalarPointer(i,j,k);				

				sum1=(T)(dataImagePointer[0]) + (T)(dataImagePointer[1]) + (T)(dataImagePointer[2]);
				sum1=sum1/(3*max);				

				surfacePoints->InsertPoint(counter, i, j, sum1*height);				

				counter ++;
			}
		}
	}

	//This cycle creates the cells of the surface
	int n =0;	
	for(i=0;i<sx-1;i++)
	{
		for(j=0;j<sy-1;j++)
		{
			for(k=0;k<sz;k++)
			{
				surfaceCells->InsertNextCell(3);
				surfaceCells->InsertCellPoint(n);
				surfaceCells->InsertCellPoint(n+1);
				surfaceCells->InsertCellPoint(n+sy+1);

				surfaceCells->InsertNextCell(3);
				surfaceCells->InsertCellPoint(n);
				surfaceCells->InsertCellPoint(n+sy+1);
				surfaceCells->InsertCellPoint(n+sy);

				if(j<sy-2)
				{
					n++;
				}
				else
				{
					n=n+2;
				}
				
			}
		}
	}
}

/*
Returns the filtered image
*/
vtkActor* Surface::getSurface()
{
	return surfaceResult;
}

