#include "vtkImageData.h"
#include "vtkImageResample.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>

class Transparency
{
	public:	
		Transparency();
		~Transparency();

		//Calculate the new image and save it in the attribute image
		void calculateImage();
		
		//Gets the result
		vtkImageData* getImage();
		
		void setImage1(vtkImageData *image);

		void setImage2(vtkImageData *image);

		void setPercent(int percent);

		//Initialize newImage points
		void initialize(int dimensions[], double spacing[]);

		//Constructs a new transparent image
		void createImage(vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY);

		//Template for constructing the image by image type
		template <class T> void createImageByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY);

	// --- Atributes --- //
	private: 

		bool _processed;

		int _type;

		vtkImageData *_image1;

		vtkImageData *_image2;

		//Resulting image
		vtkImageData *_newImage;

		//Percent of transparency for the second image
		double _percent;

		// Image 1 extent (iniX, finX, iniY, finY, iniZ, finZ)
		int extImg1[6];
		// Dimensionality image 1
		int dimImg1[3];
		// Image 1 spacing
		double spcImg1[3];

		// Image 2 extent (iniX, finX, iniY, finY, iniZ, finZ)
		int extImg2[6];
		// Dimensionality image 2
		int dimImg2[3];
		// Image 2 spacing
		double spcImg2[3];

};

