#ifndef __bbPackRecalageImageConvolution_h_INCLUDED__
#define __bbPackRecalageImageConvolution_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"
#include "Convolution.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ImageConvolution
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageConvolution,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Factor,double);
  BBTK_DECLARE_INPUT(On,bool);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  Convolution* convolution;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageConvolution,bbtk::AtomicBlackBox);
BBTK_NAME("ImageConvolution");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Processes an image through different convolution matrix (Edge detect)");
BBTK_CATEGORY("filter");
BBTK_INPUT(ImageConvolution,In,"Image to be filetered",vtkImageData*,"");
BBTK_INPUT(ImageConvolution,Factor,"Factor by how the edges will be represented",double,"");
BBTK_INPUT(ImageConvolution,On,"Boolean that represents if the filter is turned on. True = On.",bool,"");
BBTK_OUTPUT(ImageConvolution,Out,"Filtered Image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageConvolution);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageImageConvolution_h_INCLUDED__

