#ifndef __bbPackRecalageImageRecalageProperties_h_INCLUDED__
#define __bbPackRecalageImageRecalageProperties_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ImageRecalageProperties
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageRecalageProperties,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_OUTPUT(LengthZ,int);
  BBTK_DECLARE_OUTPUT(ColorLevel,int);
  BBTK_DECLARE_OUTPUT(MidColorLevel,int);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  vtkImageData *image;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageRecalageProperties,bbtk::AtomicBlackBox);
BBTK_NAME("ImageRecalageProperties");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Finds image properties necessary for image registration.");
BBTK_CATEGORY("image");
BBTK_INPUT(ImageRecalageProperties,In,"Image",vtkImageData*,"");
BBTK_OUTPUT(ImageRecalageProperties,LengthZ,"Lenght in Z",int,"");
BBTK_OUTPUT(ImageRecalageProperties,ColorLevel,"ColorLevel/WindowLevel range of the Image",int,"");
BBTK_OUTPUT(ImageRecalageProperties,MidColorLevel,"Medium value of the ColorLevel/WindowLevel range of the Image",int,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageRecalageProperties);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageImageRecalageProperties_h_INCLUDED__

