#ifndef __bbPackRecalageImageSubstraction_h_INCLUDED__
#define __bbPackRecalageImageSubstraction_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "vtkImageData.h"

#include <string>
#include <vector>

#include "Substraction.h"


namespace bbPackRecalage
{
class bbPackRecalage_EXPORT ImageSubstraction
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageSubstraction,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(In3,int);
  BBTK_DECLARE_INPUT(In4,int);
  BBTK_DECLARE_INPUT(InU,std::vector<double>);
  BBTK_DECLARE_INPUT(InM,std::vector<double>);
  BBTK_DECLARE_INPUT(InL,std::vector<double>);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
		Substraction* subImage;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageSubstraction,bbtk::AtomicBlackBox);
BBTK_NAME("ImageSubstraction");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Creates a image resulting from the substraction of the RGB values of 2 other images.");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(ImageSubstraction,In1,"Image 1",vtkImageData*,"");
BBTK_INPUT(ImageSubstraction,In2,"Image 2",vtkImageData*,"");
BBTK_INPUT(ImageSubstraction,In3,"Upper Zero Level (Value between 0 and 255)",int,"");
BBTK_INPUT(ImageSubstraction,In4,"Lower Zero Level (Value between 0 and 255)",int,"");
BBTK_INPUT(ImageSubstraction,InU,"Upper Level Color (RGB)",std::vector<double>,"");
BBTK_INPUT(ImageSubstraction,InM,"Medium Level Color (RGB)",std::vector<double>,"");
BBTK_INPUT(ImageSubstraction,InL,"Lower Level Color (RGB)",std::vector<double>,"");
BBTK_OUTPUT(ImageSubstraction,Out,"Image Result",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageSubstraction);
}
// EO namespace bbCreaRecalage

#endif // __bbCreaRecalageImageSubstraction_h_INCLUDED__

