#include "bbPackRecalageImageSwitcherBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{
	MyTimer::MyTimer(ImageSwitcherBox *box): wxTimer()
	{
		_box = box;		
	}

	MyTimer::~MyTimer()
	{
		//delete this;
	}

	void MyTimer::Notify()
	{
		//This will be called each time the timer finishes a countdown
		_box->Change();
		_box->bbSignalOutputModification(std::string("Out")); 
	}	

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ImageSwitcherBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageSwitcherBox,bbtk::WxBlackBox);

void ImageSwitcherBox::Change()
{
	//Just changes the images each time the timer finishes a countdown
	
	if(change == false)
	{
		bbSetOutputOut(bbGetInputIn2());		
		change = true;
	}
	else
	{
		bbSetOutputOut(bbGetInputIn1());
		change = false;
	}	
}

void ImageSwitcherBox::Process()
{
	time = bbGetInputTime();
	_on =  bbGetInputOn();

	if(firstTime == true)
	{
		if(bbGetInputIn1() != NULL)
		{
			bbSetOutputOut(bbGetInputIn1());
			firstTime = false;			
		}
		else if(bbGetInputIn2() != NULL)
		{
			bbSetOutputOut(bbGetInputIn2());
			firstTime = false;			
		}
	}
		
	if(myTimer == NULL)
	{
		myTimer = new MyTimer(this);
		myTimer->Start(time);
		oldTime = time;
	}
	
	if(!_on)
	{
		myTimer->Stop();
	}
	else if(!myTimer->IsRunning())
	{
		myTimer->Start(time);
		oldTime = time;
	}
	else if(oldTime != time)
	{
		myTimer->Stop();
		myTimer->Start(time);
		oldTime=time;
	}
}
void ImageSwitcherBox::CreateWidget(wxWindow* parent)
{
	//Creates a simple text widget because it is necesary that a non-empty widget exists for creatingh the thread of the timer.
	bbSetOutputWidget( new wxStaticText(parent, -1, _T("Image Switcher")) );	
}
void ImageSwitcherBox::bbUserSetDefaultValues()
{
	myTimer = NULL;
	change = false;
	time = 500;
	oldTime = 500;
	firstTime = true;
	_on=false;
}
void ImageSwitcherBox::bbUserInitializeProcessing()
{

}
void ImageSwitcherBox::bbUserFinalizeProcessing()
{
	myTimer->Stop();
	delete myTimer;
}
}
// EO namespace bbPackRecalage

