#ifdef _USE_WXWIDGETS_
#ifndef __bbPackRecalageImageSwitcherBox_h_INCLUDED__
#define __bbPackRecalageImageSwitcherBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkWxBlackBox.h"

#include "vtkImageData.h"

#include <wx/timer.h>
#include <wx/wx.h>

namespace bbPackRecalage
{
	class ImageSwitcherBox;

	class MyTimer: public wxTimer
	{
	public:
		MyTimer(ImageSwitcherBox *box);
		~MyTimer();
	virtual void Notify();

	ImageSwitcherBox *_box;
	};

class bbPackRecalage_EXPORT ImageSwitcherBox
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageSwitcherBox,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(Title,std::string);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(Time,int);
  BBTK_DECLARE_INPUT(On,bool);
  BBTK_PROCESS(Process);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

  public:
	  void Change();

  private:
	bool change;
	MyTimer *myTimer;
	int time;
	int oldTime;
	bool _on;
	bool firstTime;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageSwitcherBox,bbtk::WxBlackBox);
BBTK_NAME("ImageSwitcherBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Switches between 2 images for comparison");
BBTK_CATEGORY("__CategoryBlackBox__");
BBTK_INPUT(ImageSwitcherBox,Title,"Title prepended to the Widget",std::string,"");
BBTK_INPUT(ImageSwitcherBox,In1,"First Image",vtkImageData*,"");
BBTK_INPUT(ImageSwitcherBox,In2,"Second Image",vtkImageData*,"");
BBTK_INPUT(ImageSwitcherBox,Time,"Time between image change",int,"");
BBTK_INPUT(ImageSwitcherBox,On,"Defines if the switcher is turned on. ON = True.",bool,"");
BBTK_OUTPUT(ImageSwitcherBox,Out,"Image to be placed",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageSwitcherBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageImageSwitcherBox_h_INCLUDED__
#endif // _USE_WXWIDGETS_

