#ifndef __bbPackRecalageReSlicerBox_h_INCLUDED__
#define __bbPackRecalageReSlicerBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageReslice.h" 
#include "vtkTransform.h"
#include "vtkImageData.h"

#include "vtkIdentityTransform.h"
#include "vtkMatrix4x4.h"
#include <vtkImageChangeInformation.h>

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ReSlicerBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ReSlicerBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData *);
  BBTK_DECLARE_INPUT(Origin,std::vector<int>);
  BBTK_DECLARE_INPUT(Transform,vtkTransform *);
  BBTK_DECLARE_INPUT(Centered,bool);
  BBTK_DECLARE_INPUT(Interpolate,bool);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData *);
  BBTK_PROCESS(Process);
  void Process();

  vtkImageChangeInformation* image;
  vtkImageChangeInformation* imageResult;
  vtkImageReslice* slicer;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ReSlicerBox,bbtk::AtomicBlackBox);
BBTK_NAME("ReSlicerBox");
BBTK_AUTHOR("davila@creatis.insa-lyon.com");
BBTK_DESCRIPTION("Uses the vtk ReSlicer tool to modify an input image given a transformation filter.");
BBTK_CATEGORY("filter");
BBTK_INPUT(ReSlicerBox,In,"Image input",vtkImageData *,"");
BBTK_INPUT(ReSlicerBox,Origin,"Image Origin(x,y,z)",std::vector<int>,"");
BBTK_INPUT(ReSlicerBox,Transform,"Transform input",vtkTransform *,"");
BBTK_INPUT(ReSlicerBox,Centered,"Rotations of the image are in the center of the image. DEFAULT = False.",bool,"");
BBTK_INPUT(ReSlicerBox,Interpolate,"Linear interpolation On. DEFAULT = False.",bool,"");
BBTK_OUTPUT(ReSlicerBox,Out,"Image output",vtkImageData *,"");
BBTK_END_DESCRIBE_BLACK_BOX(ReSlicerBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageReSlicerBox_h_INCLUDED__

