#ifndef __bbPackRecalageResampleBox_h_INCLUDED__
#define __bbPackRecalageResampleBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "vtkImageResample.h"
#include "vtkImageData.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ResampleBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ResampleBox, bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData *);
  BBTK_DECLARE_INPUT(Factor,double);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData *);
  BBTK_PROCESS(Process);
  void Process();

  vtkImageResample *resample;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ResampleBox,bbtk::AtomicBlackBox);
BBTK_NAME("ResampleBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Does resampling of an image, creating a copy of the original image with different extent and spacing");
BBTK_CATEGORY("filter");
BBTK_INPUT(ResampleBox,In,"Original image",vtkImageData *,"");
BBTK_INPUT(ResampleBox,Factor,"Resampling factor",double,"");
BBTK_OUTPUT(ResampleBox,Out,"Resampled image",vtkImageData *,"");
BBTK_END_DESCRIBE_BLACK_BOX(ResampleBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageResampleBox_h_INCLUDED__

