#ifndef __bbPackRecalageSurfaceCreator_h_INCLUDED__
#define __bbPackRecalageSurfaceCreator_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "Surface.h"

#include "vtkActor.h" 

namespace bbPackRecalage
{
class bbPackRecalage_EXPORT SurfaceCreator
 : 
   public bbtk::AtomicBlackBox
{

	bool firsttime;

  Surface *surface1;
  Surface *surface2;

  vtkActorCollection *actors;

  BBTK_BLACK_BOX_INTERFACE(SurfaceCreator,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(Image1,vtkImageData*);
  BBTK_DECLARE_INPUT(Image2,vtkImageData*);
  BBTK_DECLARE_INPUT(Height1,int);
  BBTK_DECLARE_INPUT(Height2,int);
  BBTK_DECLARE_INPUT(Color1,std::string);
  BBTK_DECLARE_INPUT(Color2,std::string);
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_OUTPUT(Out1,vtkProp3D*);
  BBTK_DECLARE_OUTPUT(Out2,vtkProp3D*);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(SurfaceCreator,bbtk::AtomicBlackBox);
BBTK_NAME("SurfaceCreator");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Creates a 3D surface from a 2D image in which the height of a specific point in the surface is defined by the RGB value in the same point of the image.");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(SurfaceCreator,Image1,"Original Image 1",vtkImageData*,"");
BBTK_INPUT(SurfaceCreator,Image2,"Original Image 2",vtkImageData*,"");
BBTK_INPUT(SurfaceCreator,Height1,"Maximun height of the first surface",int,"");
BBTK_INPUT(SurfaceCreator,Height2,"Maximun height of the second surface",int,"");
BBTK_INPUT(SurfaceCreator,Color1,"Color of the first surface",std::string,"");
BBTK_INPUT(SurfaceCreator,Color2,"Color of the second surface",std::string,"");
BBTK_INPUT(SurfaceCreator,Renderer,"3D scene in which to insert the surface",vtkRenderer*,"");
BBTK_OUTPUT(SurfaceCreator,Out1,"First 3D Surface",vtkProp3D*,"");
BBTK_OUTPUT(SurfaceCreator,Out2,"Second 3D Surface",vtkProp3D*,"");
BBTK_END_DESCRIBE_BLACK_BOX(SurfaceCreator);
}
// EO namespace bbCreaRecalage

#endif // __bbCreaRecalageSurfaceCreator_h_INCLUDED__

