#ifndef __bbPackRecalageTransform3D3PointsBox_h_INCLUDED__
#define __bbPackRecalageTransform3D3PointsBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "Transformer3D.h"
#include "vtkLinearTransform.h"
#include "vtkMath.h"
#include "PlanesOperations.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT Transform3D3PointsBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(Transform3D3PointsBox,bbtk::AtomicBlackBox);

  /*Points in X*/
  BBTK_DECLARE_INPUT(InX1,std::vector<int>);

  /*Points in Y*/
  BBTK_DECLARE_INPUT(InY1,std::vector<int>);

  /*Points in Z*/
  BBTK_DECLARE_INPUT(InZ1,std::vector<int>);

  /*Points in X*/
  BBTK_DECLARE_INPUT(InX2,std::vector<int>);

  /*Points in Y*/
  BBTK_DECLARE_INPUT(InY2,std::vector<int>);

  /*Points in Z*/
  BBTK_DECLARE_INPUT(InZ2,std::vector<int>);

  /*Labels of points*/
  BBTK_DECLARE_INPUT(Labels1,std::vector<std::string>);
  /*Labels of points*/
  BBTK_DECLARE_INPUT(Labels2,std::vector<std::string>);

  /*Resultant vtkTransform*/
  BBTK_DECLARE_OUTPUT(Out, vtkTransform*);
  
  BBTK_PROCESS(Process);
  void Process();

  /*Class in charge of making the transformations*/
  Transformer3D *transformer;

  /*Class that does the vector operations*/
  PlanesOperations *planes;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Transform3D3PointsBox,bbtk::AtomicBlackBox);
BBTK_NAME("Transform3D3PointsBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Box useful for creating matrixes for 3D transformations (3 points version)");
BBTK_CATEGORY("image");
BBTK_INPUT(Transform3D3PointsBox,InX1,"Points in X (first image)",std::vector<int>,"");
BBTK_INPUT(Transform3D3PointsBox,InY1,"Points in Y (first image)",std::vector<int>,"");
BBTK_INPUT(Transform3D3PointsBox,InZ1,"Points in Z (first image)",std::vector<int>,"");
BBTK_INPUT(Transform3D3PointsBox,InX2,"Points in X (second image)",std::vector<int>,"");
BBTK_INPUT(Transform3D3PointsBox,InY2,"Points in Y (second image)",std::vector<int>,"");
BBTK_INPUT(Transform3D3PointsBox,InZ2,"Points in Z (second image)",std::vector<int>,"");
BBTK_INPUT(Transform3D3PointsBox,Labels1,"Labels of the points (first image)",std::vector<std::string>,"");
BBTK_INPUT(Transform3D3PointsBox,Labels2,"Labels of the points (second image)",std::vector<std::string>,"");
BBTK_OUTPUT(Transform3D3PointsBox,Out,"Transformation Matrix",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(Transform3D3PointsBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageTransform3DBox_h_INCLUDED__

