

MACRO(USER_BUILD_LATEX_DOC TEX_FILE OUTPUT_REL_PATH)
  # Need LaTeX
  SET(USE_LATEX ON CACHE BOOL "" FORCE)
  # Construct absolute build path
  SET(BUILD_PATH ${${PROJECT_NAME}_DOC_BUILD_PATH}/${OUTPUT_REL_PATH})
  #MESSAGE(STATUS "Tex file : ${TEX_FILE}")
  #---------------------------------------------------------------------------
  CONFIGURE_FILE(
    ${CMAKE_CURRENT_SOURCE_DIR}/${TEX_FILE}.tex
    ${BUILD_PATH}/${TEX_FILE}.tex
    COPYONLY
    )
  CONFIGURE_FILE(
    ${CMAKE_CURRENT_SOURCE_DIR}/../config.tex
    ${BUILD_PATH}/config.tex
    @ONLY
    )
  CONFIGURE_FILE(
    ${CMAKE_CURRENT_SOURCE_DIR}/../config.tex
    ${CMAKE_CURRENT_BINARY_DIR}/config.tex
    @ONLY
    )
  #---------------------------------------------------------------------------
 FILE(TO_NATIVE_PATH ${BUILD_PATH} THE_BUILD_PATH)

  # Have to run latex twice to get references, toc, etc.
  ADD_CUSTOM_COMMAND(
    OUTPUT ${BUILD_PATH}/${TEX_FILE}.aux 
    COMMAND 
    # latex
    cd ${THE_BUILD_PATH} && ${LATEX_COMPILER}
    ARGS
    -interaction=batchmode ${BUILD_PATH}/${TEX_FILE} -output-directory=${BUILD_PATH}/
    
    DEPENDS 
    ${CMAKE_CURRENT_SOURCE_DIR}/${TEX_FILE}.tex
    ${CMAKE_CURRENT_SOURCE_DIR}/../config.tex
    )
  ADD_CUSTOM_COMMAND(
    OUTPUT ${BUILD_PATH}/${TEX_FILE}.pdf
    COMMAND 
    # latex
    cd ${THE_BUILD_PATH} && ${LATEX_COMPILER}
    ARGS
    -interaction=batchmode ${BUILD_PATH}/${TEX_FILE} -output-directory=${BUILD_PATH}/
  
    DEPENDS ${BUILD_PATH}/${TEX_FILE}.aux 
    )
  
  # pdf target
  ADD_CUSTOM_TARGET(${TEX_FILE}.pdf ALL
    DEPENDS ${BUILD_PATH}/${TEX_FILE}.pdf)

  # Install
  INSTALL( 
    FILES ${BUILD_PATH}/${TEX_FILE}.pdf
    DESTINATION ${${PROJECT_NAME}_DOC_INSTALL_PATH}/${OUTPUT_REL_PATH}
    )  


ENDMACRO(USER_BUILD_LATEX_DOC)
