
#include "PlanesOperations.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

PlanesOperations::PlanesOperations()
{	
}


PlanesOperations::~PlanesOperations()
{

}


double* PlanesOperations::getCrossProduct(double* vect0,double* vect1)
{
	double* vectCross;
	vectCross = new double[3];
	vectCross[0] = vect0[1]*vect1[2]-(vect0[2]*vect1[1]);
	vectCross[1] = -(vect0[0]*vect1[2]-(vect0[2]*vect1[0]));
	vectCross[2] = vect0[0]*vect1[1]-(vect0[1]*vect1[0]);

	return vectCross;
}

double PlanesOperations::getDotProduct(double* vect0,double* vect1)
{
	double vectDot;
	vectDot = vect0[0]*vect1[0] + vect0[1]*vect1[1] + vect0[2]*vect1[2];
	
	return vectDot;
}
/**
**	Returns the magnitud of the given vector
**/
double PlanesOperations::getMagnitud(double* vect)
{
	double mag;

	mag = sqrt(pow(vect[0],2) + pow(vect[1],2) + pow(vect[2],2));

	return mag;
}
/**
**	returns the unitary vector of the given vector
**	u = 1/|vect| . vect
**/
double* PlanesOperations::getNormal(double* vect)
{

	double* vectnorm;
	double mag = getMagnitud(vect);

	vectnorm = new double[3];
	
	if(mag!=0){
		vectnorm[0] = vect[0]/mag;
		vectnorm[1] = vect[1]/mag;
		vectnorm[2] = vect[2]/mag;
	}else{
		vectnorm[0] = 0;
		vectnorm[1] = 0;
		vectnorm[2] = 0;
	}
	return vectnorm;
}

double* PlanesOperations::makeVector(double podouble0[3], double podouble1[3])
{
	double *vect;
	vect = new double[3];

	vect[0]= podouble1[0]-podouble0[0];
	vect[1]= podouble1[1]-podouble0[1];
	vect[2]= podouble1[2]-podouble0[2];

	return vect;
}

