#include "vtkImageData.h"
#include "vtkProp3D.h"
#include "vtkRenderer.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"

#include <string>

class Surface 
{
	//----------------------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------------------
	public:
	//--------------------------
	//Constructor & Destructor
	//--------------------------		
		Surface(vtkImageData* imageData, int ZHeight, std::string iColor);
		~Surface();
	//--------------------------
	//Methods
	//--------------------------
		/*
		getting ready the points
		*/
		void initialize(int dimensions[],double spacing[]);
		/*
		Calculate the new image and save it in the attribute imageResult
		it is used if the user had given the imageData
		*/
		void createSurface(vtkImageData* imageData);
		
		/*
		Returns the Surface
		*/
		vtkActor* getSurface();
		
		/*
		constructing image surface
		*/
		void surface(vtkImageData* imageData);

		/*
		Template for constructing the surface by image type
		*/
		template <class T> void surfaceByType(T* dataImagePointer, vtkImageData* imageData, T max);
		


	//----------------------------------------------------------------------------------------
	// Attributes declaration
	//----------------------------------------------------------------------------------------
	private: 
		/*
		 Surface
		*/
		vtkActor* surfaceResult;
		
		/*
		Maximun height of the surface
		*/
		int height;
		
		/*
		Color for the surface
		*/
		std::string color;

		/*
		The type of image being viewed
		*/
		int imageType;

		/*
		The points of the surface
		*/
		vtkPoints* surfacePoints;

		/*
		Cells to be constructed from the surface
		*/
		vtkCellArray* surfaceCells;
};

