
#ifndef Transformer_h
#define Transformer_h

#include "vtkTransform.h"
#include <vector>

class Transformer{
public: 
	Transformer();
    ~Transformer();
	void SetTransform(vtkTransform *transform);
	void SetCenterPoint(std::vector<int> point);
	void SetAngle(double angle);
	void SetScaleX(double scaleX);
	void SetScaleY(double scaleY);
	void SetScaleZ(double scaleZ);
	void Run();
	
    vtkTransform *GetResult();
private:
	std::vector<int> _centerPoint;
	
	double _angle;
	double _scaleX;
	double _scaleY;
	double _scaleZ;
	//vtkImageData *_image;
	vtkTransform *_transform;

	//
	vtkMatrix4x4 *_matrix;
};

#endif
