
#ifndef Transformer3D_h
#define Transformer3D_h

#include "vtkTransform.h"
#include <vector>

class Transformer3D{
public: 
	Transformer3D();
    ~Transformer3D();
	void SetTransform(vtkTransform *transform);
	void SetRotationAxis(double* axis);
	void SetFirstTranslation(double* first);
	void SetSecondTranslation(double* second);
	void SetSecondRotationAxis(double* axis);
	void SetAngle(double angle);
	void SetSecondAngle(double angle);
	void Run();
	
    vtkTransform *GetResult();
	vtkTransform *GetFirstResult();
private:
	double _rotationAxis[3];
	double _secondRotationAxis[3];
	double _firstPoint[3];
	double _secondPoint[3];
	double _angle;
	double _secondAngle;
	
	vtkTransform *_transform;
};

#endif
