
#include "Transformer3D1Point.h"
/*
	CONSTRUCTOR: Initializes the two points with empty vectors, the angle in 0.
*/
Transformer3D1Point::Transformer3D1Point() 
{
	std::vector<int> empty (3,0); 
	_centerPoint=empty;	
	//If the transform already exists, we delete it before we create a new transform 
	//and set the matrix with the identity matrix
	_transform= vtkTransform::New();
	_matrix = vtkMatrix4x4::New();
	_matrix->Identity();
	_transform->SetMatrix(_matrix);	
}

/*
	DESTRUCTOR
*/
Transformer3D1Point::~Transformer3D1Point()
{
	//We delete the existing transform
	if (_transform != NULL ) { _transform->Delete(); }
	if (_matrix != NULL ) { _matrix->Delete(); }
}

/*
	SETS A NEW TRANSFORM
*/
void Transformer3D1Point::SetTransform(vtkTransform *transform)
{
	_transform=transform;
}

/*
	SETS CENTER POINT
*/
void Transformer3D1Point::SetCenterPoint(std::vector<int> point)
{
    _centerPoint=point;
}

/*
	SETS THE ANGLE IN X
*/
void Transformer3D1Point::SetAngleX(double angle)
{
	_angleX=angle;
}

/*
	SETS THE ANGLE IN Y
*/
void Transformer3D1Point::SetAngleY(double angle)
{
	_angleY=angle;
}

/*
	SETS THE ANGLE IN Z
*/
void Transformer3D1Point::SetAngleZ(double angle)
{
	_angleZ=angle;
}

/*
	SETS THE X SCALE
*/
void Transformer3D1Point::SetScaleX(double scaleX)
{
	_scaleX=scaleX/100.0;
}

/*
	SETS THE Y SCALE
*/
void Transformer3D1Point::SetScaleY(double scaleY)
{
	_scaleY=scaleY/100.0;
}

/*
 SETS THE Y SCALE
 */
void Transformer3D1Point::SetScaleZ(double scaleZ)
{
	_scaleZ=scaleZ/100.0;
}

/*
	GETS THE RESULTANT TRANSFORM
*/
vtkTransform *Transformer3D1Point::GetResult()
{
	return _transform;
}

/*
	MAKES THE TRANSFORMATIONS
*/
void Transformer3D1Point::Run()
{	
	//Clears any old transformations in the pipeline
	_transform->Identity();

	//Make all transformations in post multiply mode
	_transform->PostMultiply();

	//Centers the image before applying the transformation
	_transform->Translate(-_centerPoint[0], -_centerPoint[1], -_centerPoint[2]);

	
	_transform->RotateWXYZ(_angleY, 0, 1, 0);
	_transform->RotateWXYZ(_angleX, 1, 0, 0);
	_transform->RotateWXYZ(_angleZ, 0, 0, 1);
	_transform->Scale(_scaleX, _scaleY,_scaleZ);

	//Returns the inverse of the transformation (NTU: Have no idea why we have to do this for the image to appear properly)
	_transform->Inverse();	
	_transform->Update();
}