
#ifndef Transformer3DV1_h
#define Transformer3DV1_h

#include "vtkTransform.h"
#include "vtkMatrix4x4.h"
#include <vector>

class Transformer3D1Point{
public: 
	Transformer3D1Point();
    ~Transformer3D1Point();
	void SetTransform(vtkTransform *transform);
	void SetCenterPoint(std::vector<int> point);
	void SetAngleX(double angle);
	void SetAngleY(double angle);
	void SetAngleZ(double angle);
	void SetScaleX(double scaleX);
	void SetScaleY(double scaleY);
	void SetScaleZ(double scaleZ);
	void Run();
	
    vtkTransform *GetResult();
private:
	std::vector<int> _centerPoint;
	double _angleX;
	double _angleY;
	double _angleZ;
	double _scaleX;
	double _scaleY;
	double _scaleZ;
	
	vtkTransform *_transform;
	vtkMatrix4x4 *_matrix;
};

#endif
