/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageCalculateVectorBox.h"
#include "bbPackRecalagePackage.h"

#include <string>

namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,CalculateVectorBox)
BBTK_BLACK_BOX_IMPLEMENTATION(CalculateVectorBox,bbtk::AtomicBlackBox);
void CalculateVectorBox::Process()
{	
	if(!bbGetInputPointsX1().empty() && !bbGetInputPointsX2().empty())
	{
		//Checks that all the vector points are defined
		if(bbGetInputPointsX1()[1] != 0 && bbGetInputPointsX2()[1] != 0)
		{
			//_vector->SetData(bbGetInputPointsX1(), bbGetInputPointsX2(), bbGetInputPointsY1(), bbGetInputPointsY2(), bbGetInputPointsZ1(), bbGetInputPointsZ2());
			//_vector->Run();

			//bbSetOutputOrigin(_vector->GetOrigin());
			//bbSetOutputOriginReslicer(_vector->GetOriginReslicer());
			//bbSetOutputOutAngle(_vector->GetAngle());
		}
	}
}
void CalculateVectorBox::bbUserSetDefaultValues()
{
	_vector = new PlanesOperations();
	std::vector<int> nullVector;
	bbSetInputPointsX1(nullVector);
	bbSetInputPointsX2(nullVector);	
}
void CalculateVectorBox::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
 
  
}
void CalculateVectorBox::bbUserFinalizeProcessing()
{
 
//  THE FINALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should desallocate the internal/output pointers  
//    if any 
  
}
}
// EO namespace bbPackRecalage


